package com.ebaiyihui.family.doctor.client;

import com.ebaiyihui.family.doctor.common.bo.MobileBenefitRes;
import com.ebaiyihui.family.doctor.common.bo.Result;
import com.ebaiyihui.family.doctor.common.vo.MobileBenefitPackageDTO;
import com.ebaiyihui.family.doctor.common.vo.RegisterPatientVo;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @ClassName: MobileBenefitPackageClient
 * @Author:yanliang
 * @Date:2024/3/19 11:35
 * @Description
 */
@FeignClient(value = "byh-family-doctor")
public interface MobileBenefitPackageClient {

    @GetMapping("/h5/login")
    @ApiOperation(value = "登陆并注册就诊卡")
    public BaseResponse<RegisterPatientVo> login(@RequestParam("token") String token);

    @PostMapping("/benefit/add")
    @ApiOperation(value = "生成权益订单同步推送")
    public Result<MobileBenefitRes> addBenefitPackage(@RequestBody List<MobileBenefitPackageDTO> vos);
}
