package com.ebaiyihui.family.doctor.client;

import com.ebaiyihui.family.doctor.common.dto.RequestServiceConfigDTO;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * @ClassName: PatientSignClient
 * @Author:yanliang
 * @Date:2024/3/15 13:46
 * @Description
 */
@FeignClient(value = "byh-family-doctor")
public interface PatientSignClient {

    /**
     * //添加/修改医生服务信息
     *
     * @param configVo
     * @return com.ebaiyihui.framework.response.BaseResponse<java.lang.Object>
     * @author:duanyl
     * @Date 2020/8/11 9:34 AM
     **/
    @ApiOperation(value = "添加/修改医生服务信息", notes = "医生服务feign调用")
    @RequestMapping(value = "/patientSign/saveServiceInfo", method = RequestMethod.POST)
    public BaseResponse<Object> saveServiceInfo(@RequestBody RequestServiceConfigDTO configVo);
}
