package com.ebaiyihui.family.doctor.common.bo;

import lombok.Data;
import lombok.ToString;

/**
 * @ClassName: Message
 * @Author:yanliang
 * @Date:2024/3/14 15:21
 * @Description
 */
@Data
@ToString
public class Message<T> {

    /**
     * 消息类型 1：不可跳转 2：可以跳转
     */
    private Integer messageType;

    /**
     * 业务编码 arc 医嘱，bookin 入院 ，order 订单详情（病例）
     * 如果是不可跳转的消息此处为空
     */
    private String businessCode;

    /**
     * 就诊id
     */
    private String admissionId;

    private String applicationCode;
    /**
     * 是否刷新：0 不刷新  1  刷新
     */
    private Integer isRefresh;

    /**
     * 转诊id
     */
    private String admId;

    /**
     * 服务类型
     */
    private Integer servType;

    /**
     * 是否团队：1.个人 2.团队
     */
    private String teamFlag;

    /**
     * 团队消息Id
     */
    private String msgId;
    /**
     * 消息数据
     */
    private T data;


    private String medicalOpinion;

    /**
     * user=指定用户发送消息，system=发送系统消息
     */
    private String actionType;

    public Integer getMessageType() {
        return messageType;
    }

    public void setMessageType(Integer messageType) {
        this.messageType = messageType;
    }

    public String getBusinessCode() {
        return businessCode;
    }

    public void setBusinessCode(String businessCode) {
        this.businessCode = businessCode;
    }

    public String getAdmissionId() {
        return admissionId;
    }

    public void setAdmissionId(String admissionId) {
        this.admissionId = admissionId;
    }

    public String getApplicationCode() {
        return applicationCode;
    }

    public void setApplicationCode(String applicationCode) {
        this.applicationCode = applicationCode;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public Integer getIsRefresh() {
        return isRefresh;
    }

    public void setIsRefresh(Integer isRefresh) {
        this.isRefresh = isRefresh;
    }

    public String getAdmId() {
        return admId;
    }

    public void setAdmId(String admId) {
        this.admId = admId;
    }

    public Integer getServType() {
        return servType;
    }

    public void setServType(Integer servType) {
        this.servType = servType;
    }

    public String getMedicalOpinion() {
        return medicalOpinion;
    }

    public void setMedicalOpinion(String medicalOpinion) {
        this.medicalOpinion = medicalOpinion;
    }

    public String getTeamFlag() {
        return teamFlag;
    }

    public void setTeamFlag(String teamFlag) {
        this.teamFlag = teamFlag;
    }

    public String getMsgId() {
        return msgId;
    }

    public void setMsgId(String msgId) {
        this.msgId = msgId;
    }

    public String getActionType() {
        return actionType;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }
}
