package com.ebaiyihui.family.doctor.common.bo;

import com.fasterxml.jackson.annotation.JsonIgnore;

import java.beans.Transient;
import java.util.Objects;

/**
 * @ClassName: Result
 * @Author:yanliang
 * @Date:2024/3/18 15:23
 * @Description
 */

public class Result<T> {
    public static final String DEFAULT_SUCCESS_MESSAGE = "success";
    public static final String DEFAULT_ERROR_MESSAGE = "failed";
    public static final String DEFAULT_SUCCESS_CODE = "200";
    public static final String DEFAULT_ERROR_CODE = "0";
    private String code;
    private String message;
    private T data;

    public Result() {
    }

    public Result(String code, String message, T data) {
        this.code = code;
        this.data = data;
        this.message = message;
    }

    public static <T> Result<T> success(Object t) {
        Result<T> res = new Result();
        res.setCode(DEFAULT_SUCCESS_CODE);
        res.setMsg(DEFAULT_SUCCESS_MESSAGE);
        res.setData((T) t);
        return res;
    }

    public static <T> Result<T> success() {
        Result<T> res = new Result();
        res.setCode(DEFAULT_SUCCESS_CODE);
        res.setMsg(DEFAULT_SUCCESS_MESSAGE);
        res.setData((T) null);
        return res;
    }

    public static <T> Result<T> error() {
        Result<T> res = new Result();
        res.setCode(DEFAULT_ERROR_CODE);
        res.setMsg(DEFAULT_ERROR_MESSAGE);
        res.setData((T) null);
        return res;
    }

    public static <T> Result<T> error(Object t) {
        Result<T> res = new Result();
        res.setCode(DEFAULT_ERROR_CODE);
        res.setMsg(DEFAULT_ERROR_MESSAGE);
        res.setData((T) t);
        return res;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return this.message;
    }

    public void setMsg(String message) {
        this.message = message;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    @Transient
    @JsonIgnore
    public boolean isSuccess() {
        return Objects.equals(this.code, "200");
    }

    public String toString() {
        return "ResultResponse [code=" + this.code + ", message=" + this.message + ", data=" + this.data + "]";
    }
}
