package com.ebaiyihui.family.doctor.common.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * @ClassName: InsertScheduleRecordReqDTO
 * @Author:yanliang
 * @Date:2024/3/14 16:22
 * @Description
 */
@Data
public class InsertScheduleRecordReqDTO {

    @ApiModelProperty(value = "医院id")
    @NotBlank(message = "医院id")
    private String hospitalId;

    @ApiModelProperty(value = "医院名称")
    @NotBlank(message = "医院名称")
    private String hospitalName;

    @ApiModelProperty(value = "医院名称")
    @NotBlank(message = "医院名称")
    private String organCode;


    @ApiModelProperty("业务类型")
    private Integer servType;

    @ApiModelProperty(value = "排班开始日期")
    @NotBlank(message = "排班开始日期")
    private String scheduleDate;

    @ApiModelProperty(value = "排班结束日期")
    @NotBlank(message = "排班结束日期")
    private String scheduleDateEnd;

    private List<ScheduleRangeAndTimeDTO> scheduleRangeAndTime;

    private List<DoctorInfoForScheduleDTO> doctorInfoForSchedule;

    @ApiModelProperty(value = "是否开通循环排班 1开通 -1未开通")
    private Integer isCycleSchedule;
}
