package com.ebaiyihui.family.doctor.common.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @ClassName: NotifyConsultDataDTO
 * @Author:yanliang
 * @Date:2024/3/19 14:27
 * @Description
 */
@Data
public class NotifyConsultDataDTO {

    private String supplierCode;

    @ApiModelProperty(value = "激活订单ID", required = true)
//    @NotBlank(message = "激活订单ID 不为空")
    private String activateOrderId;

    @ApiModelProperty(value = "问诊订单ID", required = true)
//    @NotBlank(message = "问诊订单ID 不为空")
    private String consultOrderNo;

    @ApiModelProperty(value = "订单状态（服务方提供状态映射关系）", required = true)
//    @NotBlank(message = "订单状态 不为空")
    private String status;

    @ApiModelProperty(value = "权益编码", required = true)
//    @NotBlank(message = "权益编码 不为空")
    private String productId;

    @ApiModelProperty(value = "就诊人ID（首次推送必填）", required = false)
    private String patientId;

    @ApiModelProperty(value = "接诊医生", required = false)
    private String expertName;

    @ApiModelProperty(value = "下单时间（首次推送必填）格式：yyyy-MM-dd?HH:mm:ss||yyyy/MM/ddHH:mm:ss||yyyy.MM.ddHH:mm:ss||yyyy年MM月dd日HH:mm:ss", required = true)
    private String orderDate;

    @ApiModelProperty(value = "病情描述", required = false)
    private String content;

    @ApiModelProperty(value = "私参(JSONString)?具体参数根据服务方定义", required = false)
    private String privateParams;
}
