package com.ebaiyihui.family.doctor.common.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @ClassName: QueryFamousDotDTO
 * @Author:yanliang
 * @Date:2024/3/11 09:46
 * @Description
 */
@Data
public class QueryFamousDTO {

    @ApiModelProperty("患者的登录id")
    private String userId;

    @ApiModelProperty("医疗平台编号")
    private String appCode;
    @ApiModelProperty("医院id")
    private Long organId;
    @ApiModelProperty("医院科室id")
    private Long organDeptId;
    @ApiModelProperty("搜索入参")
    private String searchParam;
    @ApiModelProperty(
            value = "业务code字符串集合",
            required = true
    )
    private String serviceCodes;
    @ApiModelProperty("标准二级科室id")
    private Long stdDeptId;
    @ApiModelProperty("排序标识")
    private Integer seq;
    @ApiModelProperty(
            value = "起始页码",
            required = true
    )
    private Integer pageNum;
    @ApiModelProperty(
            value = "每页条数",
            required = true
    )
    private Integer pageSize;
    @ApiModelProperty(
            value = "医生状态",
            hidden = true
    )
    private Integer status;

    @ApiModelProperty("患者id")
    private String patientId;
}
