package com.ebaiyihui.family.doctor.common.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * @ClassName: patientSignDoctorDTO
 * @Author:yanliang
 * @Date:2024/3/13 09:48
 * @Description
 */
@Data
public class SignedDoctorDTO {

    @ApiModelProperty("姓名")
    private String name;

    @ApiModelProperty("身份证号码")
    private String credNo;

    @ApiModelProperty("手机号码")
    private String phone;

    @ApiModelProperty("医生id")
    @NotNull(message = "医生ID不能为空")
    private Long doctorId;

    @ApiModelProperty("医生名称")
    private String doctorName;

    @ApiModelProperty("部门id")
    private Long deptId;

    @ApiModelProperty("部门名称")
    private String deptName;

    @ApiModelProperty("患者id")
    private String patientId;

    @ApiModelProperty("签约编号")
    private String admId;

    @ApiModelProperty("权益包id")
    private String packageOrderId;

    @ApiModelProperty("签约状态1.未签约2.已签约3：已解约")
    private Integer signStatus;

    @ApiModelProperty("签约id")
    private String signSeqId;

}
