package com.ebaiyihui.family.doctor.common.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @ClassName: ServiceConfigVo
 * @Author:yanliang
 * @Date:2024/3/11 09:41
 * @Description
 */
@Data
public class ServiceConfigVo {

    /**
     * 价格
     */
    private BigDecimal price;

    /**
     * 服务有效时间
     */
    private Integer servTime;

    /**
     * 每日限制人数
     */
    private Integer dailyLimit;

    /**
     * 医生回复条数限制
     */
    private Integer numLimit;

    /**
     * 公告
     */
    private String notice;

    private String serviceId;

    /**
     *   0 全天 1 上午 2下午 3夜间门诊
     */
    @ApiModelProperty(value="排班类型")
    private Date scheduleDate;


    /**
     * 排班时间
     */
    @ApiModelProperty(value="排班时间")
    private Integer scheduleRange;

    @ApiModelProperty("服务有效时间单位：1分钟，2小时")
    private Integer timeUnit;
}
