package com.ebaiyihui;

import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.circuitbreaker.EnableCircuitBreaker;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.eureka.EnableEurekaClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.transaction.annotation.EnableTransactionManagement;

/**
 * @ClassName: ByhFamilyDoctorApplcation
 * @Author:yanliang
 * @Date:2024/3/8 14:46
 * @Description
 */
@EnableDiscoveryClient
@SpringBootApplication
@EnableTransactionManagement
@EnableEurekaClient
@EnableFeignClients
@EnableCircuitBreaker
@EnableAsync
@MapperScan("com.ebaiyihui.family.doctor.server.mapper")
public class ByhFamilyDoctorApplication {

    public static void main(String[] args) {
        SpringApplication.run(ByhFamilyDoctorApplication.class, args);
    }
}
