package com.ebaiyihui.family.doctor.server.aspect;

import com.alibaba.fastjson.JSON;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;

/**
 * @program chenmt-rides
 * @description:
 * @author: chenmet
 * @create: 2019/08/09 10:58
 */

@Slf4j
@Aspect  //表明是一个切面类
@Component //将当前类注入到Spring容器内
public class LogAspect {


    //xyz.chenmt.www.chenmtrides.controller包下的所有类中的所有方法，".."表示所有方法中的参数不限个数;
    //切入点，其中execution用于使用切面的连接点。使用方法：execution(方法修饰符(可选)
    // 返回类型 方法名 参数 异常模式(可选)) ，可以使用通配符匹配字符，*可以匹配任意字符。
    @Pointcut("execution(public * com.ebaiyihui.family.doctor.server.controller.*.*(..))")
    public void LogAspect() {
    }

    Long time = 0L;

    @Before("LogAspect()")
    public void doBefore(JoinPoint joinPoint) throws Throwable {
        time = System.currentTimeMillis();
        /**
         *  接收到请求，记录请求内容
         */
        ServletRequestAttributes attributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();

        Method targetMethod = ((MethodSignature) joinPoint.getSignature()).getMethod();

        Method realMethod = joinPoint.getTarget().getClass().getDeclaredMethod(joinPoint.getSignature().getName(), targetMethod.getParameterTypes());

        ApiOperation operation = realMethod.getAnnotation(ApiOperation.class);

        /**
         * 记录下请求内容
         */
        if (Objects.nonNull(operation)){
            log.info("请求开始===方法描述:{},\n请求方法:{},\n请求地址:{},\n请求ip:{},\n请求类型:{},\n请求参数:{}", operation.value(), joinPoint.getSignature().getName(), request.getRequestURL().toString(),
                    request.getRemoteAddr(), request.getMethod(), JSON.toJSONString(Arrays.toString(joinPoint.getArgs())));
        }
    }

    @AfterReturning(returning = "ret", pointcut = "LogAspect()")
    public void doAfterReturning(Object ret) throws Throwable {

        /**
         * 处理完请求，返回内容
         */
        log.info("请求结束===返回值==>{}", JSON.toJSONString(ret));
        log.info("=======请求接口所需时间====>{}", JSON.toJSONString((System.currentTimeMillis() - time)));
    }

}
