package com.ebaiyihui.family.doctor.server.common.constants;

/**
 * @ClassName: IMInformConstants
 * @Author:yanliang
 * @Date:2024/3/14 15:23
 * @Description
 */

public class IMInformConstants {

    /**
     * 推送im消息类型-系统消息
     */
    public static final String INFORM_SYSTEM_MESSAGE_TYPE = "system";

    /**
     * 推送im消息类型-用户消息
     */
    public static final String INFORM_USER_MESSAGE_TYPE = "user";

    /**
     * im系统调用成功
     */
    public static final Integer IM_SYSTEM_SUCCESS_STATUS = 1;

    /**
     * 不可以跳转消息类型
     */
    public static final Integer SERVICE_SYSTEM_FIXATION_TYPE = 1;

    /**
     * 可跳转消息类型
     */
    public static final Integer SERVICE_SYSTEM_FREE_TYPE = 2;

    /**
     * im推送群聊消息地址
     */
    public static final String PUSH_GROUP_MESSAGE_PATH = "sendMsg/pushGroupMsg";

    /**
     * im推送单聊消息地址
     */
    public static final String PUSH_SINGLE_MESSAGE_PATH = "sendMsg/pushSingleMsg";

    /**
     * 医生appCode
     */
    public static final String DOCTOR_APPLICATION_CODE = "EHOS_DOCTOR";

    /**
     * 大众appCode
     */
    public static final String PATIENT_APPLICATION_CODE = "EHOS_PATIENT";

    /**
     * 自定义消息-病历类型
     */
    public static final String CASE_HISTORY_CUSTOM_TYPE = "order";

    public static final String CASE_HISTORY_CARD_TYPE = "card";

    public static final String CASE_HISTORY_DOCTOR_CARD_TYPE = "doctorCard";

    /**
     * 自定义消息-诊疗意见
     */
    public static final String MEDICAL_ADVICE_TYPE = "advice";

    /**
     * 自定义消息-评论类型
     */
    public static final String REVIEW_TYPE = "review";

    /**
     * 自定义消息-检查检验医嘱类型
     */
    public static final String CASE_ARC_TYPE = "arc";

    /**
     * 自定义消息-药品医嘱类型
     */
    public static final String CASE_DRUG_TYPE = "drug";

    /**
     * 自定义消息-入院证类型
     */
    public static final String CASE_BOOKIN_TYPE = "bookin";


    /**
     * im系统在线门诊（咨询）业务区分code
     */
    public static final String IM_SYSTEM_BUSINESS_CODE = "jtys";

    public static final String REFERRAL_CARD = "referralCard";


    /**
     * 统一延迟毫秒数
     */
    public static final Long COMMON_DELAY_TIME = 1000L;

    public static final String TIME = "time";

    public static final String REFERRAL_TIME = "referralTime";


    public static final Integer REFRESH = 1;

    public static final Integer NOT_REFRESH = 0;


    public static final String CASE_DOCTOR_TYPE = "treatmentCard";

    public static final String REFERRAL_COPY = "referralCopy";

    public static final String RECOMM_SERVICE = "recommService";

    public static final String BG_RECORD_DRUG = "bgRecordAndDrug";

}
