package com.ebaiyihui.family.doctor.server.common.enums;

import org.apache.commons.lang.StringUtils;

/**
 * @ClassName: GenderEnum
 * @Author:yanliang
 * @Date:2024/3/13 16:41
 * @Description
 */

public enum GenderEnum {

    /**
     * 性别 - 男
     */
    MALE("男", 1),

    /**
     * 性别 - 女
     */
    FEMALE("女", 2);

    private String desc;
    private Integer value;

    private GenderEnum(String desc, Integer value) {
        this.desc = desc;
        this.value = value;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Integer getValue() {
        return value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    public static String getDesc(Integer value) {
        if (value == null || value < 0) {
            return null;
        }
        for (GenderEnum genderEnum : GenderEnum.values()) {
            if (genderEnum.getValue().equals(value)) {
                return genderEnum.getDesc();
            }
        }
        return null;
    }

    public static GenderEnum getEnum(Integer value) {
        if (value == null || value < 0) {
            return null;
        }
        for (GenderEnum genderEnum : GenderEnum.values()) {
            if (genderEnum.getValue().equals(value)) {
                return genderEnum;
            }
        }
        return null;
    }

    public static Integer getValue(String desc) {
        if (StringUtils.isBlank(desc)) {
            return null;
        }
        for (GenderEnum genderEnum : GenderEnum.values()) {
            if (genderEnum.getDesc().equals(desc)) {
                return genderEnum.getValue();
            }
        }
        return null;
    }
}
