package com.ebaiyihui.family.doctor.server.common.enums;

/**
 * @ClassName: ScheduleRecordEnum
 * @Author:yanliang
 * @Date:2024/3/11 17:19
 * @Description
 */

public enum ScheduleRecordEnum {

    /**
     *全天
     */
    DAY("全天", 0),
    /**
     * 上午
     */
    MORNING("上午", 1),
    /**
     * 下午
     */
    AFTERNOON("下午", 2),
    /**
     * 晚上
     */
    EVENING("晚上", 3),
//==============排班状态
    /**
     * 正常
     */
    NORMAL("正常", 1),

    /**
     * 停诊
     */
    TINGZHEN("停诊", 2),
    /**
     * 复诊
     */
    VISIT("复诊", 3);




    private String desc;
    private Integer value;

    private ScheduleRecordEnum(String desc, Integer value) {
        this.desc = desc;
        this.value = value;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Integer getValue() {
        return value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    public static String getDesc(Integer value) {
        if (value == null || value < 0) {
            return null;
        }
        for (ScheduleRecordEnum scheduleRecordEnum : ScheduleRecordEnum.values()) {
            if (value.equals(scheduleRecordEnum.getValue())) {
                return scheduleRecordEnum.getDesc();
            }
        }
        return null;
    }

    public static ScheduleRecordEnum getEnum(Integer value) {
        if (value == null || value < 0) {
            return null;
        }
        for (ScheduleRecordEnum scheduleRecordEnum : ScheduleRecordEnum.values()) {
            if (value.equals(scheduleRecordEnum.getValue())) {
                return scheduleRecordEnum;
            }
        }
        return null;
    }
}
