package com.ebaiyihui.family.doctor.server.common.enums;

/**
 * @ClassName: StatusEnum
 * @Author:yanliang
 * @Date:2024/3/13 15:40
 * @Description
 */

public enum StatusEnum {
    
    IN_CONSULTATION("进行中", 2),

    FINISH_APPLY("已完成", 3),

    EXPIRED("已过期", 4);

    private String desc;
    private Integer value;

    /**
     * @param desc
     */
    private StatusEnum(String desc, Integer value) {
        this.desc = desc;
        this.value = value;
    }


    public String getDesc() {
        return desc;
    }


    public void setDesc(String desc) {
        this.desc = desc;
    }


    public Integer getValue() {
        return value;
    }


    public void setValue(Integer value) {
        this.value = value;
    }


    public static String getDesc(Integer value) {
        if (value == null || value < 0) {
            return null;
        }
        for (StatusEnum statusEnum : StatusEnum.values()) {
            if (value.equals(statusEnum.getValue())) {
                return statusEnum.getDesc();
            }
        }
        return null;
    }

    public static StatusEnum getEnum(Integer value) {
        if (value == null || value < 0) {
            return null;
        }
        for (StatusEnum statusEnum : StatusEnum.values()) {
            if (value.equals(statusEnum.getValue())) {
                return statusEnum;
            }
        }
        return null;
    }
}
