package com.ebaiyihui.family.doctor.server.common.enums;

import org.apache.commons.lang.StringUtils;

/**
 * @ClassName: WhetherEnum
 * @Author:yanliang
 * @Date:2024/3/11 17:17
 * @Description
 */

public enum WhetherEnum {

    /**
     * 允许
     */
    ALLOW("允许", 1),

    /**
     * 患者
     */
    FORBID("禁止", -1),


    EQU("相等", 0);

    private String desc;
    private Integer value;

    private WhetherEnum(String desc, Integer value) {
        this.desc = desc;
        this.value = value;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Integer getValue() {
        return value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    public static String getDesc(Integer value) {
        if (value == null || value < 0) {
            return null;
        }
        for (WhetherEnum whetherEnum : WhetherEnum.values()) {
            if (whetherEnum.getValue().equals(value)) {
                return whetherEnum.getDesc();
            }
        }
        return null;
    }

    public static WhetherEnum whetherEnum(Integer value) {
        if (value == null || value < 0) {
            return null;
        }
        for (WhetherEnum whetherEnum : WhetherEnum.values()) {
            if (whetherEnum.getValue().equals(value)) {
                return whetherEnum;
            }
        }
        return null;
    }

    public static Integer getValue(String desc) {
        if (StringUtils.isBlank(desc)) {
            return null;
        }
        for (WhetherEnum whetherEnum : WhetherEnum.values()) {
            if (whetherEnum.getDesc().equals(desc)) {
                return whetherEnum.getValue();
            }
        }
        return null;
    }
}
