package com.ebaiyihui.family.doctor.server.config;

import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.*;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.HashMap;

/**
 * @ClassName: RabbitMqConfig
 * @Author:yanliang
 * @Date:2024/3/20 11:05
 * @Description
 */
@Configuration
@Slf4j
public class RabbitMqConfig {

    /**
     * 延迟队列 TTL 名称
     */
    public static final String ORDER_DELAY_QUEUE_1 = "byh-family-doctor-delay-queue";

    /**
     * 延迟交换机
     */
    public static final String ORDER_DELAY_EXCHANGE = "byh-family-doctor-delay-exchange";

    public static final String ORDER_ROUTING_KEY_5 = "family-doctor-order-key";

    public static final String INQUIRY_END_PRE_QUEUE_NAME = "family.doctor.end.pre";

    public static final String INQUIRY_END_PRE_KEY = "family.doctor-end-pre-key";


    @Bean
    public Queue queue() {
        // 队列持久
        return new Queue("family-doctor", true);
    }

    @Bean
    DirectExchange exchange() {
        // 交换机
        return new DirectExchange("family-doctor-exchange", false, false);
    }

    @Bean
    public Binding binding() {
        // 消息队列绑定交换机
        return BindingBuilder.bind(queue()).to(exchange()).with("family-doctor");
    }

    @Bean
    public Queue delayedQueue() {
        return new Queue(ORDER_DELAY_QUEUE_1, true);
    }


    @Bean
    public CustomExchange orderDelayExchange1() {
        HashMap param = new HashMap(10);
        param.put("x-delayed-type", "direct");
        return new CustomExchange(ORDER_DELAY_EXCHANGE, "x-delayed-message", true, false, param);
    }

    @Bean
    public Binding orderBinding5() {
        return BindingBuilder.bind(delayedQueue()).to(orderDelayExchange1()).with(ORDER_ROUTING_KEY_5).noargs();
    }


    @Bean
    public Queue familyDoctorEndPreQueue() {
        return new Queue(INQUIRY_END_PRE_QUEUE_NAME, true);
    }

    @Bean
    public Binding familyDoctorEndPreBinding() {
        return BindingBuilder.bind(familyDoctorEndPreQueue()).to(orderDelayExchange1()).with(INQUIRY_END_PRE_KEY).noargs();
    }

}
