package com.ebaiyihui.family.doctor.server.config;

/**
 * @ClassName: Swagger2
 * @Author:yanliang
 * @Date:2024/3/11 09:31
 * @Description
 */

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

/**
 * @Author:yanliang
 * @Date:2019/6/12 16:00
 * @Description swagger配置类
 */
@EnableSwagger2
@Configuration
public class Swagger2 {

    /**
     *  是否开启swagger，正式环境一般是需要关闭的，可根据springboot的多环境配置进行设置
     */

    @Value(value = "${swagger.enabled}")
    Boolean swaggerEnabled;

    /**
     * swagger2的配置文件，这里可以配置swagger2的一些基本的内容，比如扫描的包等等
     */

    @Bean
    public Docket createRestApi() {
        return new Docket(DocumentationType.SWAGGER_2)
                .apiInfo(apiInfo())
                // 是否开启
                .enable(swaggerEnabled).select()
                //为当前包路径
                .apis(RequestHandlerSelectors.basePackage("com.ebaiyihui.family.doctor.server.controller"))
                .paths(PathSelectors.any())
                .build().pathMapping("/");
    }
    private ApiInfo apiInfo() {
        return new ApiInfoBuilder()
                //页面标题
                .title("家庭医生APIs")
                //描述
                .description("家庭医生api")
                //创建人
                .contact(new Contact("", "", ""))
                //版本号
                .version("1.0")
                //描述
                .build();
    }

}
