package com.ebaiyihui.family.doctor.server.controller;

import com.ebaiyihui.family.doctor.common.dto.DoctorListForScheduleReqDTO;
import com.ebaiyihui.family.doctor.common.dto.QueryDoctorsDTO;
import com.ebaiyihui.family.doctor.common.dto.SearchDoctorDayScheduleReqDTO;
import com.ebaiyihui.family.doctor.common.vo.DoctorListForScheduleResVo;
import com.ebaiyihui.family.doctor.common.vo.DoctorListVo;
import com.ebaiyihui.family.doctor.common.vo.DoctorScheduleInfoResVo;
import com.ebaiyihui.family.doctor.server.service.DoctorService;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @ClassName: DoctorController
 * @Author:yanliang
 * @Date:2024/3/11 09:38
 * @Description
 */
@RestController
@RequestMapping("/doctor")
@Api(tags = "医生API")
@Slf4j
public class DoctorController {

    @Autowired
    private DoctorService doctorService;

    @ApiOperation(value = "获取医生列表和服务次数信息", notes = "医生服务feign调用")
    @RequestMapping(value = "/getSignedDoctorList", method = RequestMethod.POST)
    public BaseResponse<PageResult<DoctorListVo>> getSignedDoctorList(@RequestBody QueryDoctorsDTO reqVo,
                                                                      BindingResult bindingResult) {


        BaseResponse<PageResult<DoctorListVo>> doctorListVo = null;
        try {
            doctorListVo = doctorService.getSignedDoctorList(reqVo);
        } catch (Exception e) {
            log.error("获取医生列表异常",e);
            return BaseResponse.error(e.getMessage());
        }
        return doctorListVo;
    }


    @ApiOperation(value = "管理端分类获取开通在线问诊的医生列表")
    @RequestMapping(value = "/getDoctorListForSchedule", method = RequestMethod.POST)
    public BaseResponse<List<DoctorListForScheduleResVo>> getDoctorListForSchedule(@RequestBody DoctorListForScheduleReqDTO req) {

        return doctorService.getDoctorListForSchedule(req);
    }

    @ApiOperation(value = "管理端搜索医生某天的排班")
    @RequestMapping(value = "/searchDoctorDaySchedule", method = RequestMethod.POST)
    public BaseResponse<DoctorScheduleInfoResVo> searchDoctorDaySchedule(@RequestBody SearchDoctorDayScheduleReqDTO reqDTO) {

        return doctorService.searchDoctorDaySchedule(reqDTO);
    }

}
