package com.ebaiyihui.family.doctor.server.controller;

import com.ebaiyihui.family.doctor.common.dto.SendImMsgDTO;
import com.ebaiyihui.family.doctor.server.service.ImMsgTemplateService;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * @ClassName: ImMsgTemplateController
 * @Author:yanliang
 * @Date:2024/3/15 10:07
 * @Description
 */
@RestController
@RequestMapping("/imMsgTemplate")
@Api(tags = "消息发送API")
@Slf4j
public class ImMsgTemplateController {

    @Autowired
    private ImMsgTemplateService imMsgTemplateService;

    @RequestMapping(value = "/sendImMsg", method = RequestMethod.POST)
    public BaseResponse<String> sendImMsg(@RequestBody SendImMsgDTO reqVo,
                                          BindingResult bindingResult) {

        BaseResponse<String> response = null;
        try {
            response = imMsgTemplateService.sendImMsg(reqVo);
        } catch (Exception e) {
            return BaseResponse.error(e.getMessage());
        }
        return BaseResponse.success("消息推送成功");
    }
}
