package com.ebaiyihui.family.doctor.server.controller;

import com.ebaiyihui.family.doctor.common.bo.MobileBenefitRes;
import com.ebaiyihui.family.doctor.common.bo.Result;
import com.ebaiyihui.family.doctor.common.vo.MobileBenefitPackageDTO;
import com.ebaiyihui.family.doctor.common.vo.RegisterPatientVo;
import com.ebaiyihui.family.doctor.server.service.MobileBenefitPackageService;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @ClassName: MobileBenefitPackageController
 * @Author:yanliang
 * @Date:2024/3/19 10:36
 * @Description
 */
@Slf4j
@RestController
@RequestMapping("/mobile/v1.0.0")
@Api(tags = "众康移动对接相关API")
public class MobileBenefitPackageController {

    @Autowired
    private MobileBenefitPackageService mobileBenefitPackageService;

    @GetMapping("/h5/login")
    @ApiOperation(value = "登陆并注册就诊卡")
    public BaseResponse<RegisterPatientVo> login(@RequestParam("token") String token) {
        return mobileBenefitPackageService.register(token);
    }

    @PostMapping("/benefit/activate")
    @ApiOperation(value = "生成权益订单同步推送")
    public Result<MobileBenefitRes> addBenefitPackage(@RequestBody List<MobileBenefitPackageDTO> vos){
        return mobileBenefitPackageService.addBenefitPackage(vos);
    }
}
