package com.ebaiyihui.family.doctor.server.controller;

import com.ebaiyihui.family.doctor.common.dto.SignedDoctorDTO;
import com.ebaiyihui.family.doctor.server.entity.PatientSignEntity;
import com.ebaiyihui.family.doctor.server.service.PatientService;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * @ClassName: PatientController
 * @Author:yanliang
 * @Date:2024/3/13 09:49
 * @Description
 */
@RestController
@RequestMapping("/patient")
@Api(tags = "患者API")
@Slf4j
public class PatientController {

    @Autowired
    private PatientService patientService;

    @ApiOperation(value = "签约医生", notes = "医生服务feign调用")
    @RequestMapping(value = "/signedDoctor", method = RequestMethod.POST)
    public BaseResponse<String> signedDoctor(@RequestBody SignedDoctorDTO reqVo,
                                             BindingResult bindingResult) {


        BaseResponse<String> response = null;
        try {
            response = patientService.signedDoctor(reqVo);
        } catch (Exception e) {
            return BaseResponse.error(e.getMessage());
        }
        return response;
    }

    @ApiOperation(value = "获取签约医生信息", notes = "医生服务feign调用")
    @RequestMapping(value = "/getSignedDoctor", method = RequestMethod.POST)
    public BaseResponse<PatientSignEntity> getSignedDoctor(@RequestBody SignedDoctorDTO reqVo,
                                                           BindingResult bindingResult) {


        BaseResponse<PatientSignEntity> response = null;
        try {
            response = patientService.getSignedDoctor(reqVo);
        } catch (Exception e) {
            return BaseResponse.error(e.getMessage());
        }
        return response;
    }
}
