package com.ebaiyihui.family.doctor.server.controller;

import com.ebaiyihui.family.doctor.common.dto.*;
import com.ebaiyihui.family.doctor.common.vo.*;
import com.ebaiyihui.family.doctor.server.service.PatientSignService;
import com.ebaiyihui.family.doctor.server.service.ServiceConfigService;
import com.ebaiyihui.family.doctor.server.util.PageUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.imforward.client.vo.IMQueryMsgReqVO;
import com.ebaiyihui.imforward.client.vo.IMQueryUserLoginReqVO;
import com.ebaiyihui.imforward.client.vo.IMQueryUserLoginRspVO;
import com.ebaiyihui.imforward.client.vo.IMSingleMsgResultVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @ClassName: PatientSignController
 * @Author:yanliang
 * @Date:2024/3/13 14:12
 * @Description
 */
@RestController
@RequestMapping("/patientSign")
@Api(tags = "患者签名API")
@Slf4j
public class PatientSignController {

    @Autowired
    private PatientSignService patientSignService;

    @Autowired
    private ServiceConfigService serviceConfigService;

    @ApiOperation(value = "查询im聊天消息记录", httpMethod = "POST", notes = "查询im消息记录")
    @RequestMapping(value = "/getMsg", method = RequestMethod.POST)
    public BaseResponse<List<IMSingleMsgResultVO>> getAllMsgContent(@RequestBody IMQueryMsgReqVO reqVO) {
        return patientSignService.getAllMsgContent(reqVO);
    }

    @ApiOperation("查询IM相关信息")
    @GetMapping("/v1/queryImInfo")
    public BaseResponse<ImInfoResVo> queryImInfo(@RequestParam("admId") String admId) {
        return patientSignService.queryImInfo(admId);
    }

    @ApiOperation("医生AppIM列表")
    @PostMapping("/v1/queryImInfoList")
    public BaseResponse<PageUtil<ImInfoListResVo>> queryImInfoList(@RequestBody ImInfoListDocReqDTO param) {
        return patientSignService.queryImInfoList(param);
    }

    @ApiOperation("医生IM详情")
    @PostMapping("/v1/queryImInfoDetail")
    public BaseResponse<ImInfoDetailDocResVo> queryImInfoDetail(@RequestBody ImInfoDetailDocReqDTO param) {
        return patientSignService.queryImInfoDetail(param);
    }

    @ApiOperation(value = "查询医生上下线状态", notes = "查询医生上下线状态")
    @RequestMapping(value = "/v1/getDoctorOfficeStatus", method = RequestMethod.POST)
    public BaseResponse<RequestOnlineOrOfflineVo> getDoctorOfficeStatus(@RequestBody RequestGetDoctorOfficeStatusDTO requestGetDoctorOfficeStatusDTO) {

        RequestOnlineOrOfflineVo onlineOrOfflineVo = new RequestOnlineOrOfflineVo();
        try {
            onlineOrOfflineVo = serviceConfigService.getDoctorOfficeStatus(requestGetDoctorOfficeStatusDTO);
        } catch (Exception e) {
            return BaseResponse.error(e.getMessage());
        }
        return BaseResponse.success(onlineOrOfflineVo);
    }

    @ApiOperation(value = "医生上下线", notes = "医生上线下线操作")
    @RequestMapping(value = "/v2/officeOnlineOrOffline", method = RequestMethod.POST)
    public BaseResponse<RequestOnlineOrOfflineVo> officeOnlineOrOffline(@RequestBody RequestOnlineOrOfflineVo requestOnlineOrOfflineVo) {
        RequestOnlineOrOfflineVo onlineOrOfflineVo = new RequestOnlineOrOfflineVo();
        try {
            onlineOrOfflineVo = serviceConfigService.officeOnlineOrOffline(requestOnlineOrOfflineVo);
        } catch (Exception e) {
            return BaseResponse.error(e.getMessage());
        }
        return BaseResponse.success(onlineOrOfflineVo);
    }

    @ApiOperation("添加/修改医生服务信息")
    @RequestMapping(value = "/saveServiceInfo", method = RequestMethod.POST)
    //@Log(value = "在线问诊",enable = true,type = LogActionType.ADD)
    public BaseResponse<Object> saveServiceInfo(@RequestBody @Validated RequestServiceConfigDTO serviceConfigDTO,
                                                BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error(bindingResult.getFieldError().getDefaultMessage());
        }
        return serviceConfigService.saveServiceInfo(serviceConfigDTO);
    }

    @ApiOperation(value = "获取im账号,==聊天界面", notes = "获取医生和病人的im账号")
    @RequestMapping(value = "/queryImAccount", method = RequestMethod.POST)
    public BaseResponse<ImAccountVo> queryImAccount(@RequestBody @Validated ImAccountReqDTO param,
                                                    BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error(bindingResult.getFieldError().getDefaultMessage());
        }
        return patientSignService.queryImAccount(param);
    }

    @ApiOperation(value = "查询APP客户端是或否需要登陆IM", httpMethod = "POST", notes = "查询APP客户端是或否需要登陆IM")
    @RequestMapping(value = "/querysdklogin", method = RequestMethod.POST)
    public BaseResponse<IMQueryUserLoginRspVO> querySdkLogin(@RequestBody IMQueryUserLoginReqVO reqVO) {
        return patientSignService.querySdkLogin(reqVO);
    }
}
