package com.ebaiyihui.family.doctor.server.controller;

import com.ebaiyihui.family.doctor.common.dto.InsertScheduleRecordReqDTO;
import com.ebaiyihui.family.doctor.common.dto.RequestGetScheduleForWeekDTO;
import com.ebaiyihui.family.doctor.common.dto.ScheduleForWeekReqDTO;
import com.ebaiyihui.family.doctor.common.vo.ResponseGetScheduleForWeekVo;
import com.ebaiyihui.family.doctor.common.vo.ScheduleForWeekResVo;
import com.ebaiyihui.family.doctor.server.service.ScheduleRecordService;
import com.ebaiyihui.framework.response.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;
import java.util.List;

/**
 * @ClassName: ScheduleRecordController
 * @Author:yanliang
 * @Date:2024/3/14 16:19
 * @Description
 */
@Slf4j
@RestController
@RequestMapping(value = "/schedulerecord")
@Api(tags = "排班API")
public class ScheduleRecordController {

    @Autowired
    private ScheduleRecordService scheduleRecordService;

    @RequestMapping(value = "/insert", method = RequestMethod.POST)
    @ApiOperation(value = "增加排班")
    public BaseResponse<String> insert(@RequestBody @Valid InsertScheduleRecordReqDTO record) {

        return scheduleRecordService.insert(record);
    }

    @RequestMapping(value = "/getscheduleforweek", method = RequestMethod.POST)
    @ApiOperation("获取医生一周的排班")
    public BaseResponse<List<ResponseGetScheduleForWeekVo>> getScheduleForWeek(@RequestBody RequestGetScheduleForWeekDTO requestGetScheduleForWeekDTO) {

        return scheduleRecordService.getScheduleForWeek(requestGetScheduleForWeekDTO);

    }

    @RequestMapping(value = "/scheduleForWeekNew", method = RequestMethod.POST)
    @ApiOperation("管理端排班列表")
    public BaseResponse<List<ScheduleForWeekResVo>> scheduleForWeekNew(@RequestBody ScheduleForWeekReqDTO scheduleForWeekReqDTO) {

        return scheduleRecordService.scheduleForWeekNew(scheduleForWeekReqDTO);

    }
}
