package com.ebaiyihui.family.doctor.server.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @ClassName: PatientSign
 * @Author:yanliang
 * @Date:2024/3/11 13:54
 * @Description
 */
@Data
@TableName(value = "patient_sign")
public class PatientSignEntity {

    @ApiModelProperty("主键id")
    @TableId
    private Long id;

    @ApiModelProperty("签约编号")
    private String admId;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("平台code")
    private String appCode;

    @ApiModelProperty("组织id")
    private Long organId;

    @ApiModelProperty("组织名称")
    private String organName;

    @ApiModelProperty("患者id")
    private String patientId;

    @ApiModelProperty("患者im用户id")
    private String patientUserId;

    @ApiModelProperty("患者名称")
    private String patientName;

    @ApiModelProperty("患者手机号码")
    private String patientPhone;

    @ApiModelProperty("身份证号码")
    private String credNo;

    @ApiModelProperty("医生id")
    private Long doctorId;

    @ApiModelProperty("医生名称")
    private String doctorName;

    @ApiModelProperty("部门id")
    private Long deptId;

    @ApiModelProperty("部门名称")
    private String deptName;

    @ApiModelProperty("签约状态1.未签约2.已签约3：已解约")
    private Integer signStatus;

    @ApiModelProperty("改签状态1、正常2、已改签")
    private Integer subStatus;

    @ApiModelProperty("业务状态2:进行中3:已完成4:已过期")
    private Integer status;

    @ApiModelProperty("权益包id")
    private String packageOrderId;

    @ApiModelProperty("签名结束时间")
    private Date signEndTime;

    @ApiModelProperty("签约关联id")
    private String signId;
}
