package com.ebaiyihui.family.doctor.server.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.Date;

/**
 * @ClassName: ScheduleRecord
 * @Author:yanliang
 * @Date:2024/3/11 13:55
 * @Description
 */
@Data
@TableName("schedule_record")
public class ScheduleRecordEntity {

    @TableId
    private Long id;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 修改时间
     */
    private Date updateTime;

    @ApiModelProperty(value = "医院id")
    @NotBlank(message = "医院id")
    private String hospitalId;

    @ApiModelProperty(value = "医院名称")
    @NotBlank(message = "医院名称")
    private String hospitalName;

    @ApiModelProperty(value = "医生ID")
    @NotBlank(message = "医生ID")
    private String doctorId;

    @ApiModelProperty(value = "医生名称")
    @NotBlank(message = "医生名称")
    private String doctorName;

    @ApiModelProperty(value = "二级科室编码")
    @NotBlank(message = "二级科室编码")
    private String deptId;

    @ApiModelProperty(value = "二级科室名称")
    @NotBlank(message = "二级科室名称")
    private String deptName;

    @ApiModelProperty(value = "总号源数")
    @NotBlank(message = "总号源数")
    private Integer totalCount;

    @ApiModelProperty(value = "可用号源数")
    @NotBlank(message = "可用号源数")
    private Integer availableCount;

    @ApiModelProperty(value = "号源日期")
    @NotBlank(message = "号源日期")
    @JsonFormat(pattern = "yyyy-MM-dd" ,timezone = "GMT+8")
    private Date scheduleDate;

    @ApiModelProperty(value = "排班类型0 全天 1 上午 2下午 3夜间门诊")
    private Integer scheduleRange;

    @ApiModelProperty(value = "排班状态")
    private Integer status;


    private String organCode;

    @ApiModelProperty("业务类型")
    private Integer servType;

    @ApiModelProperty("排班开始时间")
    private String startTime;
    @ApiModelProperty("排班结束时间")
    private String endTime;
    @ApiModelProperty("是否开启循环排班 1开启 -1关闭")
    private Integer isCycleSchedule;
}
