package com.ebaiyihui.family.doctor.server.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.Date;

/**
 * @ClassName: InquiryServiceConfig
 * @Author:yanliang
 * @Date:2024/3/11 13:55
 * @Description
 */
@Data
@TableName(value = "service_config")
public class ServiceConfigEntity {

    @TableId
    private Long id;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 更新时间
     */
    private Date updateTime;
    /**
     * 医生/团队id
     */
    @ApiModelProperty("医生Id")
    @NotBlank(message = "医生id不能为空")
    private String doctorId;

    private String organId;

    @ApiModelProperty("状态")
    private Integer status;

    private String appCode;

    @ApiModelProperty("是否有排班1/-1")
    private Integer isSchedule;

    @ApiModelProperty("上下线状态")
    private Integer officeStatus;

    private String serviceCode;

    private Long deptId;

    @ApiModelProperty("医生头像")
    private String doctorPortrait;
    @ApiModelProperty("医生职称")
    private String doctorProfession;
}
