package com.ebaiyihui.family.doctor.server.exception;

/**
 * @ClassName: BusinessException
 * @Author:yanliang
 * @Date:2024/3/13 13:47
 * @Description
 */

public class BusinessException extends RuntimeException {

    /**
     * 错误码
     */
    private String errorCode;

    public BusinessException(String errorMsg) {
        super(errorMsg);
    }


    public BusinessException(String errorCode, String errorMsg) {
        super(errorMsg);
        this.errorCode = errorCode;
    }

    public BusinessException(String errorCode, Throwable error) {
        super(error);
        this.errorCode = errorCode;
    }

    public BusinessException(String errorCode, String errorMsg, Throwable error) {
        super(errorMsg, error);
        this.errorCode = errorCode;
    }

    public String getErrorCode() {
        return errorCode;
    }
}
