package com.ebaiyihui.family.doctor.server.rabbitmq;

import com.ebaiyihui.family.doctor.server.common.enums.StatusEnum;
import com.ebaiyihui.family.doctor.server.config.RabbitMqConfig;
import com.ebaiyihui.family.doctor.server.entity.PatientSignEntity;
import com.ebaiyihui.family.doctor.server.mapper.PatientSignMapper;
import com.ebaiyihui.family.doctor.server.vo.OrderTaskVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;

import java.util.Date;

/**
 * @ClassName: RabbitConsumer
 * @Author:yanliang
 * @Date:2024/3/20 11:19
 * @Description
 */
@Slf4j
@Component
public class RabbitConsumer {

    @Autowired
    private PatientSignMapper patientSignMapper;

    @RabbitListener(queues = RabbitMqConfig.ORDER_DELAY_QUEUE_1)
    public void orderDelayQueue1(@Payload OrderTaskVo orderTaskVo) {
        log.info("定时任务监听结果：{}", orderTaskVo.toString());
        try {
            String id = orderTaskVo.getId();
            log.info("【orderDelayQueue 监听的消息】 - 【消费时间】 - [{}]- 【订单ID】 - [{}]", new Date(), id);
            PatientSignEntity patientSignEntity = patientSignMapper.selectById(id);
            if (null == patientSignEntity) {
                return;
            }

            // 存在进行中订单则将订单状态改为失效
            if (StatusEnum.IN_CONSULTATION.getValue().equals(patientSignEntity.getStatus())) {
                patientSignEntity.setStatus(StatusEnum.FINISH_APPLY.getValue());
                patientSignMapper.updateById(patientSignEntity);
            }
        } catch (Exception e) {
            log.info("orderDelayQueue监听异常", e);
            return;
        }
    }
}
