package com.ebaiyihui.family.doctor.server.rabbitmq;

import com.ebaiyihui.family.doctor.server.config.RabbitMqConfig;
import com.ebaiyihui.family.doctor.server.vo.OrderTaskVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * @ClassName: RabbitProduct
 * @Author:yanliang
 * @Date:2024/3/20 11:19
 * @Description
 */
@Component
@Slf4j
public class RabbitProduct {

    /**
     * 24小时医生未接待
     */
    private static final long EXPIRE_TIME_MAX = 24 * 60 * 60 * 1000;

    @Autowired
    private AmqpTemplate rabbitTemplate;

    public void sendDelay(OrderTaskVo orderTaskVo) {
        // 家庭医生排班医生24小时消息过期
        if (orderTaskVo.getType() == 1) {

            long time = EXPIRE_TIME_MAX;
            if (Objects.nonNull(orderTaskVo.getExpireTime())) {
                time = Long.valueOf(orderTaskVo.getExpireTime());
            }
            log.info("过期时间:{}", time);
            long finalTime = time;
            this.rabbitTemplate.convertAndSend(RabbitMqConfig.ORDER_DELAY_EXCHANGE,
                    RabbitMqConfig.ORDER_ROUTING_KEY_5, orderTaskVo, message -> {
                        message.getMessageProperties().setHeader("x-delay", finalTime);
                        message.getMessageProperties().setDeliveryMode(MessageDeliveryMode.PERSISTENT);
                        return message;
                    });
        }
    }
}
