package com.ebaiyihui.family.doctor.server.service;

import com.ebaiyihui.family.doctor.common.bo.Components;
import com.ebaiyihui.family.doctor.server.entity.PatientSignEntity;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.imforward.client.vo.IMQueryTargetSdkAccountRspVO;

import java.util.List;

/**
 * @ClassName: ImChatTemplate
 * @Author:yanliang
 * @Date:2024/3/13 11:15
 * @Description
 */

public interface ImChatTemplate {

    BaseResponse createImSession(PatientSignEntity patientSignEntity);

    /**
     * 通过admId获取Im账号
     *
     * @param admId 就诊ID
     * @param imAppCode IM设备类型
     * @return IM账号
     */
    IMQueryTargetSdkAccountRspVO queryImAccount(String admId, String imAppCode, String doctorId);

    void doctorPrompted(String admId);

    Boolean sendMsg(List<Components> componentsList, String oldAdmId, String admId);
}
