package com.ebaiyihui.family.doctor.server.service;

import com.ebaiyihui.family.doctor.common.dto.ImAccountReqDTO;
import com.ebaiyihui.family.doctor.common.dto.ImInfoDetailDocReqDTO;
import com.ebaiyihui.family.doctor.common.dto.ImInfoListDocReqDTO;
import com.ebaiyihui.family.doctor.common.vo.ImAccountVo;
import com.ebaiyihui.family.doctor.common.vo.ImInfoDetailDocResVo;
import com.ebaiyihui.family.doctor.common.vo.ImInfoListResVo;
import com.ebaiyihui.family.doctor.common.vo.ImInfoResVo;
import com.ebaiyihui.family.doctor.server.entity.PatientSignEntity;
import com.ebaiyihui.family.doctor.server.util.PageUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.imforward.client.vo.IMQueryMsgReqVO;
import com.ebaiyihui.imforward.client.vo.IMQueryUserLoginReqVO;
import com.ebaiyihui.imforward.client.vo.IMQueryUserLoginRspVO;
import com.ebaiyihui.imforward.client.vo.IMSingleMsgResultVO;

import java.util.List;

/**
 * @ClassName: PatientSignService
 * @Author:yanliang
 * @Date:2024/3/13 14:14
 * @Description
 */

public interface PatientSignService {

    /**
     * 同步会话消息
     *
     * @param reqVO
     * @return
     */

    BaseResponse<List<IMSingleMsgResultVO>> getAllMsgContent(IMQueryMsgReqVO reqVO);

    BaseResponse<ImInfoResVo> queryImInfo(String admId);

    BaseResponse<PageUtil<ImInfoListResVo>> queryImInfoList(ImInfoListDocReqDTO param);

    BaseResponse<ImInfoDetailDocResVo> queryImInfoDetail(ImInfoDetailDocReqDTO param);

    BaseResponse<ImAccountVo> queryImAccount(ImAccountReqDTO param);

    BaseResponse<IMQueryUserLoginRspVO> querySdkLogin(IMQueryUserLoginReqVO reqVO);

    List<PatientSignEntity> selectList(PatientSignEntity patientSignEntity);

    PatientSignEntity getOneByPhone(String phone);

    int updateById(PatientSignEntity patientSignEntity);
}
