package com.ebaiyihui.family.doctor.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.doctor.basedata.api.vo.BusinessDoctorPageReqVo;
import com.doctor.basedata.api.vo.DepartmentDetailVo;
import com.doctor.basedata.api.vo.DoctorBasicRespVO;
import com.doctor.basedata.api.vo.ServiceCheckReqVo;
import com.ebaiyihui.family.doctor.common.dto.DoctorListForScheduleReqDTO;
import com.ebaiyihui.family.doctor.common.dto.QueryDoctorsDTO;
import com.ebaiyihui.family.doctor.common.dto.ScheduleForWeekReqDTO;
import com.ebaiyihui.family.doctor.common.dto.SearchDoctorDayScheduleReqDTO;
import com.ebaiyihui.family.doctor.common.vo.*;
import com.ebaiyihui.family.doctor.server.common.constants.ImConstants;
import com.ebaiyihui.family.doctor.server.common.enums.SignStatus;
import com.ebaiyihui.family.doctor.server.entity.PatientSignEntity;
import com.ebaiyihui.family.doctor.server.entity.ServiceConfigEntity;
import com.ebaiyihui.family.doctor.server.feign.DepartmentFeignClient;
import com.ebaiyihui.family.doctor.server.feign.DoctorWorkingServiceClient;
import com.ebaiyihui.family.doctor.server.mapper.PatientSignMapper;
import com.ebaiyihui.family.doctor.server.mapper.ServiceConfigMapper;
import com.ebaiyihui.family.doctor.server.service.DoctorService;
import com.ebaiyihui.family.doctor.server.service.ScheduleRecordService;
import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @ClassName: DoctorServiceImpl
 * @Author:yanliang
 * @Date:2024/3/11 09:49
 * @Description
 */
@Service
@Slf4j
public class DoctorServiceImpl implements DoctorService {

    @Autowired
    private PatientSignMapper patientSignMapper;

    @Autowired
    private DepartmentFeignClient departmentInfoApi;

    @Autowired
    private ServiceConfigMapper serviceConfigMapper;

    @Autowired
    private ScheduleRecordService scheduleRecordService;

    @Autowired
    private DoctorWorkingServiceClient doctorWorkingServiceClient;

    @Override
    public BaseResponse<PageResult<DoctorListVo>> getSignedDoctorList(QueryDoctorsDTO reqVo) {
        log.info("查询医生入参：" + JSONObject.toJSONString(reqVo));
//        if (StringUtils.isNotEmpty(reqVo.getSearchParam()) && StringUtils.isNotEmpty(reqVo.getUserId())) {
//            redisHistory(reqVo);
//        }

        //执业机构
        String wOrganId = reqVo.getOrganId().toString();
        //2。查询上次选择医生
        QueryWrapper<PatientSignEntity> wrapper = new QueryWrapper<>();
        PatientSignEntity patientSignEntity = new PatientSignEntity();
        patientSignEntity.setPatientId(reqVo.getPatientId());
        patientSignEntity.setOrganId(reqVo.getOrganId());
        patientSignEntity.setSignStatus(SignStatus.SIGNED.getValue());
        wrapper.setEntity(patientSignEntity);
        wrapper.orderByDesc("create_time");
        wrapper.last("limit 1");
        PatientSignEntity entity = patientSignMapper.selectOne(wrapper);
        boolean LastSignFlag = false;
        log.info("患者上次绑定-用来处理上次选择的医生：entity{}", JSON.toJSONString(entity));

        PageResult pageResult = new PageResult();

        //先开服务 再看排班 前面为准
        List<DoctorBasicRespVO> docBaseList = getDoctors(reqVo);

        if (CollectionUtils.isEmpty(docBaseList)) {
            pageResult.setContent(new ArrayList());
            pageResult.setPageNum(reqVo.getPageNum());
            pageResult.setPageSize(reqVo.getPageSize());
            return BaseResponse.success(pageResult);
        }
        log.info("用于循环的集合{}", JSON.toJSONString(docBaseList));
        List<DoctorListVo> doctorListVos = new ArrayList<>();

        for (DoctorBasicRespVO dto : docBaseList) {
            Integer doctorId = dto.getXId().intValue();
            DoctorListVo doctorListVo = new DoctorListVo();
            //评分
            BeanUtils.copyProperties(dto, doctorListVo);
            doctorListVo.setTitle(dto.getStandardTitle());
            doctorListVo.setDoctorId(doctorId.toString());
            doctorListVo.setOrganId(Integer.valueOf(wOrganId));
            doctorListVo.setDeptId(dto.getDeptId().intValue());
            doctorListVo.setPhoneNum(dto.getTelephone());
            doctorListVo.setLastSign(0);

            //上下线
//            getDoctorOfficeStatusAndDoctorLabel(reqVo, dto.getDeptId(), dto.getOrganId(), doctorId, doctorListVo);

            //如果有模糊搜索医生姓名时, 不置顶上次选择的医生，有科室帅选 的时候 不置顶上次选择的 医生
            //去除掉上次选择的医生数据
//            if (null != entity
//                    && entity.getDoctorId().equals(dto.getXId().toString())
//                    && StringUtils.isEmpty(reqVo.getSearchParam())
//                    && null == (reqVo.getOrganDeptId())) {
//                log.info("去除掉上次选择的医生======" + JSON.toJSONString(dto));
//                LastSignFlag = true;
//                continue;
//            }
            //处理 有搜索参数时，并且是上次选择 的医生
            if (null != entity && String.valueOf(entity.getDoctorId()).equals(dto.getXId().toString())) {
//                if (StringUtils.isNotEmpty(reqVo.getSearchParam()) || null != (reqVo.getOrganDeptId())) {
                log.info("进入上次选择医生信息");
                doctorListVo.setLastSign(1);
                doctorListVos.add(0, doctorListVo);
                continue;
//                }
            }

            doctorListVos.add(doctorListVo);
        }
        //针对上次选择的医生进行处理
        //如果有模糊搜索医生姓名时, 不置顶上次选择的医生，有科室帅选 的时候 不置顶上次选择的 医生
//        if (LastSignFlag) {
//            isLastSign(reqVo, doctorListVos, wOrganId, entity, doctorZxwzService);
//        }
        pageResult.setPageNum(reqVo.getPageNum());
        pageResult.setPageSize(doctorListVos.size());
//        pageResult.setPageSize(reqVo.getPageSize());
//        pageResult.setTotalPages(businessDoctorPage.getData().getTotalPages());
//        pageResult.setTotal(businessDoctorPage.getData().getTotal());
        pageResult.setContent(doctorListVos);
        return BaseResponse.success(pageResult);
    }

    @Override
    public BaseResponse<List<DoctorListForScheduleResVo>> getDoctorListForSchedule(DoctorListForScheduleReqDTO req) {
        //通过医院ID和服务查找开通服务 开通排班 的医生
        BusinessDoctorPageReqVo businessDoctorPageReqVo = new BusinessDoctorPageReqVo();

        businessDoctorPageReqVo.setSeq(1);
        businessDoctorPageReqVo.setStatus(1);
        businessDoctorPageReqVo.setOrganId(req.getHospitalId());
        businessDoctorPageReqVo.setPageNum(1);
        businessDoctorPageReqVo.setPageSize(9999);
        businessDoctorPageReqVo.setServiceCode(ImConstants.IM_QUERY_ACCOUNT_CODE);

        BaseResponse<PageResult<DoctorBasicRespVO>> result =
                doctorWorkingServiceClient.getBusinessDoctorBaseInfoPage(businessDoctorPageReqVo);
        if (!result.isSuccess()) {
            return BaseResponse.error("医生查询失败");
        }
        if (null == result || null == result.getData()) {
            return BaseResponse.error("无开通家庭医生的医生");
        }

        log.info("查询开通家庭医生医生列表{}", JSON.toJSONString(result.getData().getContent()));

        ArrayList<DoctorListForScheduleResVo> listForScheduleVos = new ArrayList<>();

        for (DoctorBasicRespVO doctorBasicRespVO : result.getData().getContent()) {
            QueryWrapper<ServiceConfigEntity> queryWrapper = new QueryWrapper<>();
            ServiceConfigEntity serviceConfig = new ServiceConfigEntity();
            serviceConfig.setServiceCode(ImConstants.IM_QUERY_ACCOUNT_CODE);
            serviceConfig.setDeptId(doctorBasicRespVO.getDeptId());
            serviceConfig.setDoctorId(doctorBasicRespVO.getXId().toString());
            serviceConfig.setOrganId(doctorBasicRespVO.getOrganId().toString());
            serviceConfig.setIsSchedule(1);
            serviceConfig.setStatus(1);
            queryWrapper.setEntity(serviceConfig);
            List<ServiceConfigEntity> serviceConfigEntities = serviceConfigMapper.selectList(queryWrapper);
            if (CollectionUtils.isEmpty(serviceConfigEntities)) {
                log.info("未查询到医生服务信息,或此医生未开通排班");
                continue;
            }

            serviceConfigEntities.stream().forEach(one -> {

                //查在线医生服务是否开通
                ServiceCheckReqVo serviceCheckReqVo = new ServiceCheckReqVo();
                serviceCheckReqVo.setDoctorId(doctorBasicRespVO.getXId());
                serviceCheckReqVo.setOrganId(doctorBasicRespVO.getOrganId());
                serviceCheckReqVo.setDeptId(one.getDeptId());
                serviceCheckReqVo.setServiceCode(serviceConfig.getServiceCode());
                BaseResponse<Boolean> response = doctorWorkingServiceClient.checkDoctorServiceByCode(serviceCheckReqVo);
                if (!response.isSuccess() || !response.getData()) {
                    log.info("医生该科室未开通家庭医生服务:{}", one.getDeptId());
                    return;
                }
                if (StringUtils.isEmpty(one.getDoctorPortrait()) || StringUtils.isEmpty(one.getDoctorProfession())) {
                    //把医生头像和职称更新进去
                    ServiceConfigEntity serviceUpdate = new ServiceConfigEntity();
                    serviceUpdate.setDoctorPortrait(doctorBasicRespVO.getPortrait());
                    serviceUpdate.setDoctorProfession(doctorBasicRespVO.getStandardTitle());
                    serviceUpdate.setId(one.getId());
                    serviceConfigMapper.updateById(serviceUpdate);
                }
                DoctorListForScheduleResVo doctorForScheduleVo = new DoctorListForScheduleResVo();
                doctorForScheduleVo.setDoctorId(doctorBasicRespVO.getXId().toString());
                doctorForScheduleVo.setDoctorName(doctorBasicRespVO.getDoctorName());
                BaseResponse<DepartmentDetailVo> departmentDetail = departmentInfoApi.getDepartmentDetail(Long.valueOf(one.getDeptId()));
                doctorForScheduleVo.setDeptName(departmentDetail.getData().getDeptName());
                doctorForScheduleVo.setDeptId(one.getDeptId().toString());

                listForScheduleVos.add(doctorForScheduleVo);
            });
        }
        return BaseResponse.success(listForScheduleVos);
    }

    @Override
    public BaseResponse<DoctorScheduleInfoResVo> searchDoctorDaySchedule(SearchDoctorDayScheduleReqDTO reqDTO) {
        DoctorScheduleInfoResVo doctorScheduleInfoResVo = new DoctorScheduleInfoResVo();
        doctorScheduleInfoResVo.setScheduleTime(reqDTO.getScheduleTime());

        ScheduleForWeekReqDTO scheduleForWeek = new ScheduleForWeekReqDTO();
        scheduleForWeek.setHospitalId(reqDTO.getHospitalId());
        scheduleForWeek.setServType(reqDTO.getServType());
        scheduleForWeek.setWeek(reqDTO.getWeek());
        if (StringUtils.isNotEmpty(reqDTO.getDoctorName())) {
            scheduleForWeek.setDoctorName(reqDTO.getDoctorName());
        }
        BaseResponse<List<ScheduleForWeekResVo>> pageResultBaseResponse = scheduleRecordService.scheduleForWeekNew(scheduleForWeek);

        if (!pageResultBaseResponse.isSuccess()) {
            return BaseResponse.error("单周排班调用失败");
        }
        List<ScheduleForWeekResVo> content = pageResultBaseResponse.getData();

        if (CollectionUtils.isEmpty(content)) {
            return BaseResponse.success();
        }
        content = content.stream().filter(scheduleForWeekNew -> {
            if (scheduleForWeekNew.getScheduleTime().compareTo(reqDTO.getScheduleTime()) == 0) {
                return true;
            }
            return false;
        }).collect(Collectors.toList());

        if (CollectionUtils.isEmpty(content)) {
            return BaseResponse.success();
        }
        log.info("过滤出当前选择日期的content只有一条{}", content.toString());

        List<ScheduleInfoVo> scheduleInfos = new ArrayList<>();
        content.get(0).getScheduleInfos().stream().forEach(schedule -> {
            scheduleInfos.add(schedule);
        });
        doctorScheduleInfoResVo.setScheduleInfos(scheduleInfos);
        return BaseResponse.success(doctorScheduleInfoResVo);
    }

//    private void redisHistory(QueryFamousDotDTO reqVo) {
//
//        //把搜索的数据存在map中
//        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
//        String value = simpleDateFormat.format(new Date());
//        log.info("===========value===========:" + value);
//        //先判断redis中的map是否有值
//        String redisValue = redisUtil.get(reqVo.getUserId());
//        //如果redis中没有map,则新建map,存入redis
//        if (null == redisValue) {
//            Map map = new LinkedHashMap<String, String>();
//            map.put(reqVo.getSearchParam(), value);
//            log.info("map的大小为:" + map.size());
//            //存在map中,将map存入redis
//            String jsonString = JSON.toJSONString(map);
//            redisUtil.set(reqVo.getUserId(), jsonString);
//            //如果redis里面有map,直接拿出来,存入数据,在放入redis
//        } else {
//            Map<String, String> redisMap = JSONObject.parseObject(redisValue, Map.class);
//            //如果大小比5小,直接数据放入map中
//            if (redisMap.size() < 5) {
//                //查看map中是否有插入的key
//                boolean flag = redisMap.containsKey(reqVo.getSearchParam());
//                //则表示map中不包含,可以直接插入
//                if (!flag) {
//                    redisMap.put(reqVo.getSearchParam(), value);
//                } else {
//                    //如果map中包含,则先删除原有的,在重新放入
//                    redisMap.remove(reqVo.getSearchParam());
//                    redisMap.put(reqVo.getSearchParam(), value);
//                }
//                redisMap.put(reqVo.getSearchParam(), value);
//                String jsonString = JSON.toJSONString(redisMap);
//                redisUtil.set(reqVo.getUserId(), jsonString);
//                log.info("redis中size<5的map的大小为:" + redisMap.size());
//            } else {
//                //讲map按照value降序,时间最早的就是最后一个
//                Map<String, String> mapResult = sortByValue(redisMap, true);
//                log.info("排序后的map有序map为:" + mapResult);
//
//                boolean flag = mapResult.containsKey(reqVo.getSearchParam());
//                //则表示map中不包含,可以直接插入
//                if (!flag) {
//                    //获取redis的最后一个元素
//                    Field tail = null;
//                    try {
//                        tail = mapResult.getClass().getDeclaredField("tail");
//                    } catch (NoSuchFieldException e) {
//                        e.printStackTrace();
//                    }
//                    tail.setAccessible(true);
//                    Map.Entry<String, String> entry = null;
//                    try {
//                        entry = (Map.Entry<String, String>) tail.get(mapResult);
//                    } catch (IllegalAccessException e) {
//                        e.printStackTrace();
//                    }
//                    String key = entry.getKey();
//                    log.info("删除的最早的一条记录的key是:" + key);
//                    mapResult.remove(key);
//                    log.info("删除一条记录的map为" + mapResult);
//
//                    mapResult.put(reqVo.getSearchParam(), value);
//                } else {
//                    //如果map中包含,则先删除原有的,在重新放入
//                    mapResult.remove(reqVo.getSearchParam());
//                    mapResult.put(reqVo.getSearchParam(), value);
//                }
//
//                log.info("重新放入一条记录的map为" + mapResult);
//
//                String jsonString = JSON.toJSONString(mapResult);
//                redisUtil.set(reqVo.getUserId(), jsonString);
//                log.info("redis中map的大小为:" + redisMap.size());
//            }
//        }
//    }

    private List<DoctorBasicRespVO> getDoctors(QueryDoctorsDTO reqVo) {
        List<DoctorBasicRespVO> docBaseList = new ArrayList<>();
        List<DoctorBasicRespVO> resultData = new ArrayList<>();
        List<Long> depts = reqVo.getDepts();
        if (!CollectionUtils.isEmpty(depts)) {
            log.info("多科室显示");
            depts.stream().forEach(i -> {
                BusinessDoctorPageReqVo businessDoctorPageReqVo = new BusinessDoctorPageReqVo();
                reqVo.setSeq(1);
                reqVo.setStatus(1);
                BeanUtils.copyProperties(reqVo, businessDoctorPageReqVo);
                businessDoctorPageReqVo.setOrganDeptId(i);
                businessDoctorPageReqVo.setServiceCode(reqVo.getServiceCodes());
                BaseResponse<PageResult<DoctorBasicRespVO>> doctors = doctorWorkingServiceClient.getBusinessDoctorBaseInfoPage(businessDoctorPageReqVo);
                if (!CollectionUtils.isEmpty(doctors.getData().getContent())) {
                    List<DoctorBasicRespVO> vos = doctors.getData().getContent();
                    resultData.addAll(vos);
                }
            });
        } else {
            BusinessDoctorPageReqVo businessDoctorPageReqVo = new BusinessDoctorPageReqVo();
            reqVo.setSeq(1);
            reqVo.setStatus(1);
            BeanUtils.copyProperties(reqVo, businessDoctorPageReqVo);
            businessDoctorPageReqVo.setServiceCode(reqVo.getServiceCodes());
            log.info("医生数据入参" + JSON.toJSONString(businessDoctorPageReqVo));
            BaseResponse<PageResult<DoctorBasicRespVO>> businessDoctorPage =
                    doctorWorkingServiceClient.getBusinessDoctorBaseInfoPage(businessDoctorPageReqVo);
            log.info("医生数据出参" + JSON.toJSONString(businessDoctorPage.getData()));
            if (null == businessDoctorPage.getData()) {
                return new ArrayList<>();
            }
            resultData.addAll(businessDoctorPage.getData().getContent());

            if (CollectionUtils.isEmpty(resultData)) {
                return new ArrayList<>();
            }
            List<DoctorBasicRespVO> collect = resultData.stream().filter(vo -> ("5").equals(vo.getAduitStatus())).collect(Collectors.toList());
            docBaseList.addAll(collect);
        }
        return docBaseList;
    }

//    private void getDoctorOfficeStatusAndDoctorLabel(QueryFamousDotDTO reqVo, Long deptId, Long organId, Integer doctorId, DoctorListVo doctorListVo) {
//        //3.查询医生上下线状态
//        RequestGetDoctorOfficeStatusVo requestGetDoctorOfficeStatus = new RequestGetDoctorOfficeStatusVo();
//        requestGetDoctorOfficeStatus.setAppCode(reqVo.getAppCode());
//        requestGetDoctorOfficeStatus.setDoctorId(doctorId.toString());
//        requestGetDoctorOfficeStatus.setHospitalId(reqVo.getOrganId().toString());
//        RequestOnlineOrOfflineVo requestOnlineOrOfflineVo = inquiryServiceConfigService.getDoctorOfficeStatus(requestGetDoctorOfficeStatus);
//        if (null != requestOnlineOrOfflineVo) {
//            doctorListVo.setOfficeStatus(requestOnlineOrOfflineVo.getOfficeStatus());
//            log.info("医生是否在线:" + requestOnlineOrOfflineVo.getOfficeStatus());
//        }
//    }

//    private void isLastSign(QueryFamousDotDTO reqVo, List<DoctorListVo> doctorListVos, String wOrganId, PatientSignEntity patientSignEntity, ZXWZServiceBo doctorZxwzService) {
//        // 查询医生的服务是否可购买 新版更新为从数据库获取
//        QueryWrapper<InquiryServiceConfigEntity> queryWrapper = new QueryWrapper<>();
//        InquiryServiceConfigEntity wrapperEntity = new InquiryServiceConfigEntity();
//        wrapperEntity.setDoctorId(orderEntity.getDoctorId());
//        wrapperEntity.setOrganId(orderEntity.getHospitalId());
//        wrapperEntity.setStatus(CommonConstants.STATUS_VALID.intValue());
//        wrapperEntity.setServiceCode(reqVo.getServiceCodes());
//        wrapperEntity.setDeptId(orderEntity.getDeptId());
//        log.info("wrapperEntity:{}" + JSON.toJSONString(wrapperEntity));
//        queryWrapper.setEntity(wrapperEntity);
//        queryWrapper.last("limit 1");
//        if (StringUtils.isNotEmpty(reqVo.getReserveTime()) && !"1".equals(reqVo.getReserveTime())) {
//            queryWrapper.in("is_schedule", 2, 3);
//        }
//        InquiryServiceConfigEntity inquiryServiceConfigEntity = inquiryServiceConfigService.getOne(queryWrapper);
//
//        if (null != inquiryServiceConfigEntity) {
//            log.info("inquiryServiceConfigEntity:{}" + inquiryServiceConfigEntity.toString());
//            //查询上次选择的医生数据
//            //查询医生数据
//            // 封装 获取医生信息的请求类
//            QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
//            queryPersonnelInfoReq.setDoctorId(orderEntity.getDoctorId());
//
//            // Feign请求获取医生信息
//            BaseResponse<PersonnelInfo> personnelInfoBaseResponse =
//                    doctorCilent.queryPersonnelInfo(queryPersonnelInfoReq);
//            log.info("req :{}", JSON.toJSONString(personnelInfoBaseResponse));
//
//            //查询医生评分
//            DoctorListVo doctorListVo = new DoctorListVo();
//
//            //判断团队服务
//            BaseResponse<Boolean> docIsLearder = doctorTemInfomService.getDocIsLearder(orderEntity.getDoctorId(), wOrganId);
//            List<GetPersonTeamDetialResVo> personTeamNew = doctorTemInfomService.getPersonTeamNew(orderEntity.getDoctorId());
//            if (docIsLearder.isSuccess() && docIsLearder.getData() && personTeamNew != null) {
//                doctorListVo.setDoctorType(DoctorTypeEnum.TEAM.getValue());
//            } else {
//                doctorListVo.setDoctorType(DoctorTypeEnum.PERSONAL.getValue());
//            }
//
//            //装填doctorListVo
//            PersonnelInfo baseResponseData = personnelInfoBaseResponse.getData();
//            BeanUtils.copyProperties(baseResponseData, doctorListVo);
//
//            ServiceConfigVo serviceConfigVo = new ServiceConfigVo();
//            serviceConfigVo.setPrice(doctorZxwzService.getServicePrice());
//            serviceConfigVo.setDailyLimit(doctorZxwzService.getNumLimit());
//            serviceConfigVo.setNumLimit(doctorZxwzService.getReplyLimit());
//            serviceConfigVo.setServTime(doctorZxwzService.getEffectiveTime());
//            doctorListVo.setServiceConfigData(serviceConfigVo);
//
//            doctorListVo.setOrganId(Integer.valueOf(wOrganId));
//            doctorListVo.setLastSelect(new Integer("1"));
//            doctorListVo.setDoctorId(baseResponseData.getDoctorId());
//            String doctorScorel = "5.0";
//            BaseResponse<String> doctorAverageScorel =
//                    doctorUserEvaluationFeignClient.getDoctorAverageScore(doctorListVo.getDoctorId());
//            if (null != doctorAverageScorel && null != doctorAverageScorel.getData()) {
//                doctorScorel = "0.0".equals(doctorAverageScorel.getData()) ? "5.0" : doctorAverageScorel.getData();
//            }
//            doctorListVo.setSatisfaction(doctorScorel);
//            doctorListVo.setServTimes(getDoctorServTimes(orderEntity.getDoctorId(), orderEntity.getOrganId(),
//                    orderEntity.getServType()));
//            QueryWrapper query = new QueryWrapper();
//            AdmissionEntity wrapper = new AdmissionEntity();
//            wrapper.setDoctorId(baseResponseData.getDoctorId());
//            List list = new ArrayList();
//            list.add(1);
//            list.add(2);
//            wrapper.setServType(orderEntity.getServType());
//            query.setEntity(wrapper);
//            query.in("status", list);
//            int inService = baseInquiryAdmissionService.count(query);
//            Long deptId = baseResponseData.getDeptId().longValue();
//            Long organId = baseResponseData.getOrganId().longValue();
//            Integer doctorId = Integer.parseInt(baseResponseData.getDoctorId());
//            getDoctorOfficeStatusAndDoctorLabel(reqVo, deptId, organId, doctorId, doctorListVo);
//            doctorListVo.setInService(inService);
//            //把数据放到医生列表第一列
//            doctorListVos.add(0, doctorListVo);
//        }
//    }
}
