package com.ebaiyihui.family.doctor.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.doctoruser.api.pojo.vo.*;
import com.ebaiyihui.family.doctor.common.dto.GoeasyPushMsgReqDTO;
import com.ebaiyihui.family.doctor.server.common.constants.IMInformConstants;
import com.ebaiyihui.family.doctor.server.common.constants.ProjProperties;
import com.ebaiyihui.family.doctor.server.common.constants.UrlConstants;
import com.ebaiyihui.family.doctor.server.common.enums.StatusEnum;
import com.ebaiyihui.family.doctor.server.entity.PatientSignEntity;
import com.ebaiyihui.family.doctor.server.mapper.PatientSignMapper;
import com.ebaiyihui.family.doctor.server.service.GoEasyPushService;
import com.ebaiyihui.family.doctor.server.util.UserRestTemplateUtil;
import com.ebaiyihui.framework.utils.HttpKit;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * @ClassName: GoEasyPushServiceImpl
 * @Author:yanliang
 * @Date:2024/3/15 16:30
 * @Description
 */
@Service
@Slf4j
public class GoEasyPushServiceImpl implements GoEasyPushService {

    @Autowired
    private ProjProperties projProperties;

    @Autowired
    private PatientSignMapper patientSignMapper;

    @Async
    @Override
    public void newOrderToReceive(String admId) {
        log.info("医生web端推送开始:{}", admId);

        QueryWrapper<PatientSignEntity> wrapper = new QueryWrapper<>();
        PatientSignEntity patientSign = new PatientSignEntity();
        patientSign.setAdmId(admId);
        wrapper.setEntity(patientSign);
        PatientSignEntity patientSignEntity = patientSignMapper.selectOne(wrapper);

        //是否订单
        boolean isOrder = Objects.equals(StatusEnum.IN_CONSULTATION.getValue(), patientSignEntity.getStatus());

        if (isOrder) {
            UserInfoByUserIdRespVO userInfoByUserIdRespVO = queryDocAccountInfo(String.valueOf(patientSignEntity.getDoctorId()));
            String userId = userInfoByUserIdRespVO.getUserId();

            Map<String, String> map = new HashMap<>();
            map.put("id", patientSignEntity.getAdmId());
            map.put("body", "您有一笔新的家庭医生订单待处理，请及时查看");
            map.put("type", "jtys_new_order");
            map.put("title", "家庭医生订单提醒");
            map.put("subTitle", "家庭医生订单提醒");
            map.put("pushCode", "1");

            goEasyPush(userId, JSON.toJSONString(map), IMInformConstants.IM_SYSTEM_BUSINESS_CODE);
        }
    }

    /**
     * @param docId 医生ID
     * @return 医生userId
     */
    private UserInfoByUserIdRespVO queryDocAccountInfo(String docId) {
        // 查询医生userId
        FindUserIdListReq findUserIdListReq = new FindUserIdListReq();
        FindUserIdReqVO findUserIdReqVO = new FindUserIdReqVO();
        findUserIdReqVO.setReqId(docId);
        findUserIdReqVO.setUserType((short) 1);
        List<FindUserIdReqVO> findUserIdReqVOList = new ArrayList<>(1);
        findUserIdReqVOList.add(findUserIdReqVO);
        findUserIdListReq.setFindUserIdReqVOS(findUserIdReqVOList);
        log.info("findUserIdListReq:{}", JSON.toJSONString(findUserIdListReq));
        //查询医生userId
        List<com.doctoruser.api.pojo.vo.FindUserIdRespVO> findUserIdRespVOS =
                UserRestTemplateUtil.queryUserIdList(findUserIdListReq, projProperties.getUserFindUserId());


        log.info("00001查询用户Id请求对象:{}", JSON.toJSONString(findUserIdRespVOS));
        if (null == findUserIdRespVOS) {
            return null;
        }

        FindUserIdRespVO findUserIdRespVO = findUserIdRespVOS.get(0);
        log.info("000========:{}", JSON.toJSONString(findUserIdRespVO));
        // 查询医生账号信息
        GetUserInfoByUserIdReqVO getUserInfoByUserIdReqVO = new GetUserInfoByUserIdReqVO();
        getUserInfoByUserIdReqVO.setUserId(findUserIdRespVO.getUserId());

        log.info("0002获取用户基础资料请求对象入参:{}", JSON.toJSONString(getUserInfoByUserIdReqVO));

        //获取用户基础资料
        UserInfoByUserIdRespVO userInfo =
                UserRestTemplateUtil.getUserInfo(getUserInfoByUserIdReqVO, projProperties.getUserInfo());

        log.info("0002获取用户基础资料请求对象出参:{}", JSON.toJSONString(userInfo));
        if (null != userInfo) {
            return userInfo;
        }
        return null;
    }

    public void goEasyPush(String userId, String text, String busiCode) {

        String url = projProperties.getBaseAddress() + UrlConstants.GO_EASY_PUSH;
        try {
            log.info("goeasy推送url----------->{}", url);
            GoeasyPushMsgReqDTO vo = new GoeasyPushMsgReqDTO();
            vo.setBusiCode(busiCode);
            vo.setBody(text);
            vo.setUserId(userId);
            log.info("=======>goeasy推送参数----->{}", JSON.toJSONString(vo));
            String httpResult = HttpKit.jsonPost(url, JSON.toJSONString(vo));
            log.info("=======>goeasy推送返回结果----->{}", httpResult);
        } catch (Exception e) {
            log.info("=======>goeasy推送 - 获取异常", e);
        }
    }
}
