package com.ebaiyihui.family.doctor.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.doctoruser.api.pojo.base.dto.doctor.QueryPersonnelInfoReq;
import com.doctoruser.api.pojo.base.vo.doctor.PersonnelInfo;
import com.doctoruser.api.pojo.vo.UserInfoByDoctorIdRespVO;
import com.doctoruser.api.pojo.vo.UserInfoByUserIdRespVO;
import com.ebaiyihui.family.doctor.common.bo.*;
import com.ebaiyihui.family.doctor.common.dto.DoctorIdDTO;
import com.ebaiyihui.family.doctor.server.common.constants.CommonConstants;
import com.ebaiyihui.family.doctor.server.common.constants.IMInformConstants;
import com.ebaiyihui.family.doctor.server.common.constants.ImConstants;
import com.ebaiyihui.family.doctor.server.common.enums.SenderEnum;
import com.ebaiyihui.family.doctor.server.entity.PatientSignEntity;
import com.ebaiyihui.family.doctor.server.exception.BusinessException;
import com.ebaiyihui.family.doctor.server.feign.DoctorInfofeignClient;
import com.ebaiyihui.family.doctor.server.feign.IMPushMsgFeignClient;
import com.ebaiyihui.family.doctor.server.feign.ImApiFeignClient;
import com.ebaiyihui.family.doctor.server.feign.UserApiFeignClient;
import com.ebaiyihui.family.doctor.server.mapper.PatientSignMapper;
import com.ebaiyihui.family.doctor.server.service.ImChatTemplate;
import com.ebaiyihui.family.doctor.server.util.JsonUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.imforward.client.vo.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @ClassName: ImChatTemplateImpl
 * @Author:yanliang
 * @Date:2024/3/13 11:15
 * @Description
 */
@Service
@Slf4j
public class ImChatTemplateImpl implements ImChatTemplate {

    @Autowired
    private UserApiFeignClient userApiFeignClient;

    @Autowired
    private DoctorInfofeignClient doctorInfofeignClient;

    @Autowired
    private ImApiFeignClient imApiFeignClient;

    @Autowired
    private IMPushMsgFeignClient imPushMsgFeignClient;

    @Autowired
    private PatientSignMapper patientSignMapper;

    @Override
    public BaseResponse createImSession(PatientSignEntity patientSignEntity) {

        //创建 IM Session
        log.info("=======创建会话开始=====");

        log.info("创建会话开始时间：{}" + System.currentTimeMillis());
        log.info("patientSignEntity :{}", patientSignEntity);

        BaseResponse response = createPersonalImSession(patientSignEntity);
        log.info("创建会话返回:{}" + JSON.toJSONString(response));
        log.info("=======创建会话结束=====");
        log.info("创建会话结束时间：{}" + System.currentTimeMillis());
        return response;
    }

    @Override
    public IMQueryTargetSdkAccountRspVO queryImAccount(String admId, String imAppCode, String doctorId) {
        log.info("admId:" + admId);
        log.info("imAppCode:" + imAppCode);
        if (StringUtils.isEmpty(admId)) {
            return null;
        }
        QueryWrapper<PatientSignEntity> wrapper = new QueryWrapper<>();
        PatientSignEntity patientSign = new PatientSignEntity();
        patientSign.setAdmId(admId);
        wrapper.setEntity(patientSign);
        PatientSignEntity patientSignEntity = patientSignMapper.selectOne(wrapper);

        if (patientSignEntity == null) {
            return null;
        }
        log.info("patientSignEntity:" + patientSignEntity.toString());
        IMQueryTargetSdkAccountReqVO imQueryTargetSdkAccountReqVO = new IMQueryTargetSdkAccountReqVO();
        if (ImConstants.IM_DOC_ACCOUNT_NUM.equals(imAppCode)) {

            // 查询医生账号
            BaseResponse<UserInfoByDoctorIdRespVO> response = userApiFeignClient.getUserInfoByDoctorId(doctorId);
            log.info("response:{}", JsonUtil.convertObject(response));
            if (response.isSuccess()) {
                UserInfoByDoctorIdRespVO userInfoByDoctorIdRespVO = response.getData();
                log.info("userInfoByDoctorIdRespVO:{}" + JSONObject.toJSONString(userInfoByDoctorIdRespVO));

                imQueryTargetSdkAccountReqVO.setUserId(userInfoByDoctorIdRespVO.getUserId());
            }

        } else if (ImConstants.IM_PAT_ACCOUNT_NUM.equals(imAppCode)) {
            // 查询患者账号
            imQueryTargetSdkAccountReqVO.setUserId(patientSignEntity.getPatientUserId());
        }
        imQueryTargetSdkAccountReqVO.setBusiCode(ImConstants.IM_QUERY_ACCOUNT_CODE);
        imQueryTargetSdkAccountReqVO.setAppCode(imAppCode);
        imQueryTargetSdkAccountReqVO.setTreatmentId(admId);

        log.info("imQueryTargetSdkAccountReqVO:{}" + JSONObject.toJSONString(imQueryTargetSdkAccountReqVO));
        BaseResponse<IMQueryTargetSdkAccountRspVO> response = imApiFeignClient
                .qeuryTagetSdkAccount(imQueryTargetSdkAccountReqVO);
        log.info("imApiFeignClient-response{}", JSON.toJSONString(response));
        if (response.isSuccess()) {
            return response.getData();
        }
        log.warn("IM账号查询 - 查询失败 - response:{}", JsonUtil.convertObject(response));
        return null;
    }

    @Override
    public void doctorPrompted(String admId) {
        String content = "";
        List<MessageInfo> messageInfos = new ArrayList<>();
        PatientSignInfo patientSignInfo = getPatientSignInfo(admId);
        messageInfos.add(getDoctorInformRefreshPatientParam(patientSignInfo, IMInformConstants.REFRESH));
        PersonImInformReq parameter = new PersonImInformReq();
        parameter.setMessageInfos(messageInfos);
        parameter.setAdmissionId(admId);
        parameter.setBusiCode(IMInformConstants.IM_SYSTEM_BUSINESS_CODE);
        log.info("推送家庭医生提示语推送：{}" + JSON.toJSONString(parameter.getMessageInfos()));
        if (personUserImInform(parameter, content, null)) {
            log.info("推送家庭医生提示语推送成功，admissionId:{}", admId);
        }
    }

    @Override
    public Boolean sendMsg(List<Components> componentsList, String oldAdmId, String admId) {
        Boolean flag = false;
        if (!componentsList.isEmpty()) {
            log.info("componentsList={}", componentsList);
            for (int i = 0; i < componentsList.size(); i++) {
                String content = componentsList.get(i).getContent();
                List<MessageInfo> messageInfos = new ArrayList<>();
                PatientSignInfo patientSignInfo = getPatientSignInfo(admId);
                MessageInfo messageInfo = new MessageInfo();
                content = MessageFormat.format(content, patientSignInfo.getDoctorName());
                if (!StringUtils.isEmpty(oldAdmId)) {
                    PatientSignInfo oldPatientSignInfo = getPatientSignInfo(oldAdmId);
                    content = MessageFormat.format(content, oldPatientSignInfo.getDoctorName(), patientSignInfo.getDoctorName());
                }
                if (SenderEnum.DOCTOR.getDesc().equals(componentsList.get(i).getSender())) {
                    messageInfo = getDoctorInformRefreshPatientParam(patientSignInfo, IMInformConstants.REFRESH);
                } else {
                    messageInfo = getInformRefreshPatientParam(patientSignInfo, IMInformConstants.REFRESH);
                }
                messageInfos.add(messageInfo);
                PersonImInformReq parameter = new PersonImInformReq();
                parameter.setMessageInfos(messageInfos);
                parameter.setAdmissionId(admId);
                parameter.setBusiCode(IMInformConstants.IM_SYSTEM_BUSINESS_CODE);
                log.info("推送家庭医生提示语推送：{}" + JSON.toJSONString(parameter.getMessageInfos()));
                Long syncFlag = i * 100L;
                if (personUserImInform(parameter, content, syncFlag)) {
                    log.info("推送家庭医生提示语推送成功，admissionId:{}", admId);
                    flag = true;
                }
            }

        }

        return flag;
    }

    /**
     * 获取im推送需要的信息
     * 1.serviceType  2.0 病人账号 2.1 病人名字 3.3 医生生名字  账号 6.拒绝理由 7.订单号
     * 团队的 1.groupId （注意状态，销毁了就不能发） 2.serviceType 3.0 病人用户账号 3.1 病人名字
     * 4.团队的所有医生bean（id，账号，姓名） 5.团队名字 6 拒绝理由 7订单号
     *
     * @param admId
     * @return
     * @description 公共方法
     */
    private PatientSignInfo getPatientSignInfo(String admId) {
        QueryWrapper<PatientSignEntity> wrapper = new QueryWrapper<>();
        PatientSignEntity patientSign = new PatientSignEntity();
        patientSign.setAdmId(admId);
        wrapper.setEntity(patientSign);
        PatientSignEntity patientSignEntity = patientSignMapper.selectOne(wrapper);
        if (patientSignEntity == null) {
            log.error("IM INFORM ERROR : 没有查询到就诊信息，admId:{}", admId);
            return new PatientSignInfo();
        }
        PatientSignInfo patientSignInfo = new PatientSignInfo();
        BeanUtils.copyProperties(patientSignEntity, patientSignInfo);

        // 获取医生基本信息
        QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
        queryPersonnelInfoReq.setDoctorId(String.valueOf(patientSignEntity.getDoctorId()));
        BaseResponse<PersonnelInfo> doctorInfo = doctorInfofeignClient.queryPersonnelInfo(queryPersonnelInfoReq);
        // 调用用户系统查询医生userId
        UserInfoByUserIdRespVO userInfoByUserIdRespVO = queryDocAccountInfo(String.valueOf(patientSignEntity.getDoctorId()));
        if (userInfoByUserIdRespVO == null) {
            log.error("IM INFORM ERROR : 获取医生信息失败 doctorId：{}", String.valueOf(patientSignEntity.getDoctorId()));
            return new PatientSignInfo();
        }
        if (null == doctorInfo && !doctorInfo.isSuccess()) {
            log.error("IM INFORM ERROR : 获取医生信息失败 doctorId：{}", String.valueOf(patientSignEntity.getDoctorId()));
            return new PatientSignInfo();
        }
        patientSignInfo.setDoctorUserId(userInfoByUserIdRespVO.getUserId());
        log.info("patientSignInfo:{}" + JSON.toJSONString(patientSignInfo));
        return patientSignInfo;
    }

    private <T> MessageInfo getDoctorInformRefreshPatientParam(PatientSignInfo patientSignInfo, Integer isRefresh) {
        String patientUserId = patientSignInfo.getPatientUserId();
        if (org.apache.commons.lang3.StringUtils.isEmpty(patientUserId)) {
            log.error("IM INFORM ERROR : 无法查询到接收人信息");
            return new MessageInfo();
        }
        MessageInfo messageInfo = new MessageInfo();
        Message<T> message = new Message<>();
//        message.setData(content);
//        messageInfo.setMessage(message);
        message.setApplicationCode(IMInformConstants.IM_SYSTEM_BUSINESS_CODE);
        messageInfo.setSingleAccount(newAccount(IMInformConstants.PATIENT_APPLICATION_CODE, patientUserId));
        messageInfo.setSelfAccount(newAccount(IMInformConstants.DOCTOR_APPLICATION_CODE,
                patientSignInfo.getDoctorUserId()));
        messageInfo.setMessage(message);
        return messageInfo;
    }

    private <T> MessageInfo getInformRefreshPatientParam(PatientSignInfo patientSignInfo, Integer isRefresh) {
        String doctorUserId = patientSignInfo.getDoctorUserId();
        if (StringUtils.isEmpty(doctorUserId)) {
            log.error("IM INFORM ERROR : 无法查询到接收人信息");
            return new MessageInfo();
        }
        MessageInfo messageInfo = new MessageInfo();
        Message<T> message = new Message<>();
//        message.setData(content);
//        messageInfo.setMessage(message);
        message.setApplicationCode(IMInformConstants.IM_SYSTEM_BUSINESS_CODE);
        messageInfo.setSingleAccount(newAccount(IMInformConstants.DOCTOR_APPLICATION_CODE, doctorUserId));
        messageInfo.setSelfAccount(newAccount(IMInformConstants.PATIENT_APPLICATION_CODE, patientSignInfo.getPatientUserId()));
        messageInfo.setMessage(message);
        return messageInfo;
    }

    private AccountVO newAccount(String appCode, String userId) {
        AccountVO accountVO = new AccountVO();
        accountVO.setAppCode(appCode);
        accountVO.setUserId(userId);
        return accountVO;
    }

    /**
     * 推送医生消息
     *
     * @param param
     * @return
     */
    private boolean personUserImInform(PersonImInformReq param, String content, Long syncFlag) {
        List<MessageInfo> messageInfos = param.getMessageInfos();
        if (messageInfos == null || messageInfos.isEmpty()) {
            log.error("IM INFORM ERROR : 没有可发送的消息");
            return false;
        }
        List<PushSingleMsgDataVO> msgSingleDatas = new ArrayList<>();
        messageInfos.forEach(e -> {
            PushSingleMsgDataVO msgsingleData = new PushSingleMsgDataVO();
            //医生发送消息
            msgsingleData.setActionType(IMInformConstants.INFORM_USER_MESSAGE_TYPE);
            msgsingleData.setFromAccount(e.getSelfAccount());
            msgsingleData.setToAccount(e.getSingleAccount());
            if (Objects.nonNull(syncFlag)) {
                msgsingleData.setSyncFlag(syncFlag);
            }
            msgsingleData.setMessage(content);
            msgSingleDatas.add(msgsingleData);
        });
        PushSingleMsgReqVO parameter = new PushSingleMsgReqVO();
        parameter.setBusiCode(param.getBusiCode());
        parameter.setUniqueId(param.getAdmissionId());
        parameter.setMsgData(msgSingleDatas);
        // 发送IM单人推送
        log.info("推送入参:{}" + JSON.toJSONString(parameter));

        boolean pushFlag = pushSingleIm(parameter);
        if (pushFlag != true) {
            log.info("IM INFORM ERROR : im 调用im系统推送失败");
            return false;
        }
        return true;
    }

    /**
     * @param reqVO 请求参数
     * @return boolean 发送结果
     * @description: 发送IM单人推送
     * @author fangyueguo
     * @date 2019年02月19日
     */
    private boolean pushSingleIm(PushSingleMsgReqVO reqVO) {
        log.info("调用IM第三方reqVO:{}" + JSON.toJSONString(reqVO));
        BaseResponse<?> response = imPushMsgFeignClient.pushSingleMsg(reqVO);
        log.info("发送IM单人推送:{}", response.toString());
        return response.isSuccess();
    }


    private BaseResponse createPersonalImSession(PatientSignEntity patientSignEntity) {
        BaseResponse baseResponse = new BaseResponse();
        String doctorId = String.valueOf(patientSignEntity.getDoctorId());
        log.info("DoctorId:{}" + doctorId);

        UserInfoByUserIdRespVO docAccountInfo = queryDocAccountInfo(doctorId);
        if (docAccountInfo == null) {
//            throw new BusinessException("创建IMsession失败,调用查询医生userId失败，未查询到医生信息!");
        }

        log.info("开始创建单人im账号");
        DoctorIdDTO doctorIdVo = new DoctorIdDTO();
        doctorIdVo.setDoctorId(doctorId);
        ImAccountCreateReq imAccountCreateReq = new ImAccountCreateReq(patientSignEntity.getAdmId(),
                doctorId, patientSignEntity.getPatientId(),
                docAccountInfo.getUserId(), patientSignEntity.getPatientUserId(), patientSignEntity.getAppCode());
        IMSaveSessionReqVO imSaveSessionReqVO = createImSessionParam(imAccountCreateReq);
        log.info("创建im入参{}", JSONObject.toJSONString(imSaveSessionReqVO));
        BaseResponse<?> imResponse = null;
        if (null != imSaveSessionReqVO) {
            log.info("创建im请求开始");
            imResponse = imApiFeignClient.saveIMSession(imSaveSessionReqVO);
            log.info("创建im请求结果：{}", JsonUtil.convertObject(imResponse));
        } else {
            throw new BusinessException("createImSession fail!");
        }
        return imResponse;
    }

    private UserInfoByUserIdRespVO queryDocAccountInfo(String doctorId) {

        BaseResponse<UserInfoByDoctorIdRespVO> response = userApiFeignClient.getUserInfoByDoctorId(doctorId);
        log.info("response:{}", JsonUtil.convertObject(response));

        UserInfoByUserIdRespVO userInfoByUserIdRespVO = new UserInfoByUserIdRespVO();
        if (response.isSuccess()) {

            userInfoByUserIdRespVO.setUserId(response.getData().getUserId());
            log.info("UserInfoByUserIdRespVO===>{}", JSON.toJSONString(userInfoByUserIdRespVO));
            return userInfoByUserIdRespVO;
        }

        return null;
    }

    /**
     * 创建IM Session参数
     *
     * @param req 传入数据
     * @author Fu Chao
     */
    private IMSaveSessionReqVO createImSessionParam(ImAccountCreateReq req) {
        IMSaveSessionReqVO reqVO = new IMSaveSessionReqVO();
        reqVO.setBusiCode(ImConstants.IM_QUERY_ACCOUNT_CODE);
        reqVO.setSdkType(ImConstants.IM_QUERY_TYPE_TENCENT);
        reqVO.setTreatmentId(req.getAdmId());
        reqVO.setBusiNodeCode(req.getAppCode());
        reqVO.setSaveType(true);

        IMSessionMemberVO memberOfDoc = new IMSessionMemberVO();
        List<IMSessionMemberVO> datas = new ArrayList<>();

        memberOfDoc.setAppCode(ImConstants.IM_DOC_ACCOUNT_NUM);
        memberOfDoc.setDoctorId(CommonConstants.DOCTOR_TYPE.toString());
        memberOfDoc.setPatientId(CommonConstants.STATUS_INVALID.toString());
        memberOfDoc.setUserId(req.getDoctorUserId());
        datas.add(memberOfDoc);

        IMSessionMemberVO memberOfPatient = new IMSessionMemberVO();
        memberOfPatient.setAppCode(ImConstants.IM_PAT_ACCOUNT_NUM);
        memberOfPatient.setDoctorId(CommonConstants.STATUS_INVALID.toString());
        memberOfPatient.setPatientId(CommonConstants.PATIENT_TYPE.toString());
        memberOfPatient.setUserId(req.getPatientUserId());
        datas.add(memberOfPatient);
        reqVO.setMemberList(datas);

        return reqVO;
    }
}
