package com.ebaiyihui.family.doctor.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.family.doctor.common.bo.Components;
import com.ebaiyihui.family.doctor.common.bo.MsgContent;
import com.ebaiyihui.family.doctor.common.dto.SendImMsgDTO;
import com.ebaiyihui.family.doctor.server.entity.ImMsgTemplateEntity;
import com.ebaiyihui.family.doctor.server.exception.BusinessException;
import com.ebaiyihui.family.doctor.server.mapper.ImMsgTemplateMapper;
import com.ebaiyihui.family.doctor.server.service.ImChatTemplate;
import com.ebaiyihui.family.doctor.server.service.ImMsgTemplateService;
import com.ebaiyihui.framework.response.BaseResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @ClassName: ImMsgTemplateServiceImpl
 * @Author:yanliang
 * @Date:2024/3/15 10:06
 * @Description
 */
@Service
public class ImMsgTemplateServiceImpl implements ImMsgTemplateService {

    @Autowired
    private ImMsgTemplateMapper imMsgTemplateMapper;

    @Autowired
    private ImChatTemplate imChatTemplate;

    @Async
    @Override
    public BaseResponse<String> sendImMsg(SendImMsgDTO reqVo) {

        QueryWrapper<ImMsgTemplateEntity> wrapper = new QueryWrapper<>();
        ImMsgTemplateEntity imMsgTemplate = new ImMsgTemplateEntity();
        imMsgTemplate.setAppCode(reqVo.getAppCode());
        imMsgTemplate.setOrganId(reqVo.getOrganId());
        imMsgTemplate.setType(reqVo.getType());
        wrapper.setEntity(imMsgTemplate);
        ImMsgTemplateEntity imMsgTemplateEntity = imMsgTemplateMapper.selectOne(wrapper);
        String components = imMsgTemplateEntity.getContent();
        MsgContent msgContent = JSON.parseObject(components, MsgContent.class);
        List<Components> componentsList = msgContent.getComponents().stream().sorted(Comparator.comparing(Components::getSort)).collect(Collectors.toList());
        Boolean flag = imChatTemplate.sendMsg(componentsList, reqVo.getOldAdmId(), reqVo.getAdmId());
        if (!flag) {
            throw new BusinessException("消息推送失败");
        }
        return BaseResponse.success("消息推送成功");
    }
}
