package com.ebaiyihui.family.doctor.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.card.common.CardServiceApi;
import com.ebaiyihui.card.common.vo.CardDetailsInfoRespVO;
import com.ebaiyihui.card.common.vo.RegisterCardReqVO;
import com.ebaiyihui.family.doctor.common.bo.MobileBenefitRes;
import com.ebaiyihui.family.doctor.common.bo.Result;
import com.ebaiyihui.family.doctor.common.vo.MobileBenefitPackageDTO;
import com.ebaiyihui.family.doctor.common.vo.RegisterPatientVo;
import com.ebaiyihui.family.doctor.server.common.constants.CommonConstants;
import com.ebaiyihui.family.doctor.server.entity.MobileBenefitPackageEntity;
import com.ebaiyihui.family.doctor.server.entity.PatientEntity;
import com.ebaiyihui.family.doctor.server.entity.PatientSignEntity;
import com.ebaiyihui.family.doctor.server.mapper.MobileBenefitPackageMapper;
import com.ebaiyihui.family.doctor.server.mapper.PatientMapper;
import com.ebaiyihui.family.doctor.server.mapper.PatientSignMapper;
import com.ebaiyihui.family.doctor.server.service.MobileBenefitPackageService;
import com.ebaiyihui.family.doctor.server.util.DESUtils;
import com.ebaiyihui.framework.response.BaseResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @ClassName: MobileBenefitPackageServiceImpl
 * @Author:yanliang
 * @Date:2024/3/19 10:37
 * @Description
 */
@Slf4j
@Service
public class MobileBenefitPackageServiceImpl implements MobileBenefitPackageService {

    @Autowired
    private CardServiceApi cardServiceFeignClient;

    @Autowired
    private PatientMapper patientMapper;

    @Autowired
    private PatientSignMapper patientSignMapper;

    @Autowired
    private MobileBenefitPackageMapper mobileBenefitPackageMapper;

    @Override
    public BaseResponse<RegisterPatientVo> register(String token) {
        token = token.replace(" ", "+");
        Map<String, String> map = JSONObject.parseObject(DESUtils.decrypt(token, CommonConstants.DES_SECRET), Map.class);
        log.info("解析token结果：{}", map);
        MobileBenefitPackageEntity entity = mobileBenefitPackageMapper.queryByPhone(map.get("mobile"), map.get("activateOrderId"));
        if (ObjectUtils.isEmpty(entity)) {
            return BaseResponse.error("没有查询到有关权益");
        }
        //注册就诊卡
        RegisterCardReqVO registerCardReqVO = new RegisterCardReqVO();
        registerCardReqVO.setAppCode("NCZK");
        registerCardReqVO.setChannelCode("PATIENT_WX");
        registerCardReqVO.setChannelName("PATIENT_WX");
        registerCardReqVO.setPatientName(map.get("patientName"));
        registerCardReqVO.setCredNo(map.get("card_no"));
        registerCardReqVO.setCredTypeCode("01");
        registerCardReqVO.setCredTypeName("居民身份证");
        registerCardReqVO.setCardTypeCode("1703");
        registerCardReqVO.setCardTypeName("虚拟就诊卡");
        registerCardReqVO.setOrganCode("130188");
        registerCardReqVO.setOrganName("南昌众康医院");
        registerCardReqVO.setTel(map.get("mobile"));

        log.info("注册就诊卡请求:{}", registerCardReqVO);
        BaseResponse<CardDetailsInfoRespVO> response = cardServiceFeignClient.registerOrBindCard(registerCardReqVO);
        log.info("注册就诊卡结果:{}", response);

        if (!response.isSuccess() || StringUtils.isEmpty(response)) {
            return BaseResponse.error("注册就诊卡失败");
        }
        CardDetailsInfoRespVO data = response.getData();
        RegisterPatientVo registerPatientVo = new RegisterPatientVo();
        registerPatientVo.setPatientInfo(data);
        registerPatientVo.setActivateOrderId(map.get("activateOrderId"));
        if (Objects.nonNull(map.get("admId"))) {
            registerPatientVo.setAdmId(map.get("admId"));

            // 更新权益医生id
            QueryWrapper<PatientSignEntity> psWrapper = new QueryWrapper<>();
            PatientSignEntity patientSign = new PatientSignEntity();
            patientSign.setAdmId(map.get("admId"));
            psWrapper.setEntity(patientSign);
            PatientSignEntity patientSignEntity = patientSignMapper.selectOne(psWrapper);
            if (Objects.nonNull(patientSignEntity)) {
                entity.setDoctorId(String.valueOf(patientSignEntity.getDoctorId()));
                mobileBenefitPackageMapper.updateDoctorId(entity);
            }
        }
        if (Objects.nonNull(map.get("scheduleFlag"))) {
            registerPatientVo.setScheduleFlag(Integer.valueOf(map.get("scheduleFlag")));
        }
        if (Objects.nonNull(map.get("msgPushType"))) {
            registerPatientVo.setMsgPushType(Integer.valueOf(map.get("msgPushType")));
        }

        if (Objects.nonNull(map.get("signSeqId"))) {
            registerPatientVo.setSignSeqId(map.get("signSeqId"));
            PatientSignEntity patientSignEntity = patientSignMapper.selectById(Long.valueOf(map.get("signSeqId")));
            registerPatientVo.setAdmId(patientSignEntity.getAdmId());
            // 更新权益医生id
            if (Objects.nonNull(patientSignEntity)) {
                entity.setDoctorId(String.valueOf(patientSignEntity.getDoctorId()));
                mobileBenefitPackageMapper.updateDoctorId(entity);
            }

        }

        String patientId = map.get("patient_id");
        if (!StringUtils.isEmpty(patientId)) {
            // 查询患者信息
            QueryWrapper<PatientEntity> wrapper = new QueryWrapper<>();
            PatientEntity patient = new PatientEntity();
            patient.setId(data.getPatientId());
            wrapper.setEntity(patient);
            PatientEntity patientEntity = patientMapper.selectOne(wrapper);
            if (Objects.isNull(patientEntity)) {
                patientEntity = new PatientEntity();
                patientEntity.setId(data.getPatientId());
                patientEntity.setPatientName(data.getPatientName());
                patientEntity.setPhone(data.getTel());
                patientEntity.setPatientType(CommonConstants.PATIENT_TYPE);
                patientEntity.setGender(Integer.valueOf(data.getGender()));
                patientEntity.setBirthDates(data.getBirth());
                patientEntity.setCredNo(data.getCredNo());
                patientEntity.setUserId(entity.getUserId());
                log.info("数据库不存在添加患者: {}", JSON.toJSONString(patientEntity));
                patientMapper.insert(patientEntity);
            }
            //保存就诊人id
            entity.setUserId(map.get("patient_id"));
            mobileBenefitPackageMapper.update(entity);
        }
        return BaseResponse.success(registerPatientVo);
    }

    @Override
    public Result<MobileBenefitRes> addBenefitPackage(List<MobileBenefitPackageDTO> vos) {
        log.info("推送订单信息:{}", vos);
        try {
            vos.forEach(vo -> {
                MobileBenefitPackageEntity entity = new MobileBenefitPackageEntity();
                BeanUtils.copyProperties(vo, entity);
                mobileBenefitPackageMapper.insert(entity);
            });
        } catch (Exception e) {
            log.error("保存权益包信息失败：{}", e.getMessage());
            return Result.error(failed());
        }
        return Result.success(success());
    }

    private MobileBenefitRes success() {
        MobileBenefitRes resp = new MobileBenefitRes();
        resp.setOrderStatus("OOS");
        resp.setOrderDesc("成功");
        return resp;
    }

    private MobileBenefitRes failed() {
        MobileBenefitRes resp = new MobileBenefitRes();
        resp.setOrderStatus("OOF");
        resp.setOrderDesc("失败");
        return resp;
    }
}
