package com.ebaiyihui.family.doctor.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.doctoruser.api.pojo.base.dto.doctor.QueryPersonnelInfoReq;
import com.doctoruser.api.pojo.base.vo.doctor.PersonnelInfo;
import com.ebaiyihui.family.doctor.common.dto.ImAccountReqDTO;
import com.ebaiyihui.family.doctor.common.dto.ImInfoDetailDocReqDTO;
import com.ebaiyihui.family.doctor.common.dto.ImInfoListDocReqDTO;
import com.ebaiyihui.family.doctor.common.vo.*;
import com.ebaiyihui.family.doctor.server.common.constants.IMInformConstants;
import com.ebaiyihui.family.doctor.server.common.constants.ImConstants;
import com.ebaiyihui.family.doctor.server.common.enums.SignStatus;
import com.ebaiyihui.family.doctor.server.common.enums.StatusEnum;
import com.ebaiyihui.family.doctor.server.entity.PatientEntity;
import com.ebaiyihui.family.doctor.server.entity.PatientSignEntity;
import com.ebaiyihui.family.doctor.server.feign.DoctorInfofeignClient;
import com.ebaiyihui.family.doctor.server.feign.IMSyncMsgClient;
import com.ebaiyihui.family.doctor.server.feign.ImApiFeignClient;
import com.ebaiyihui.family.doctor.server.mapper.PatientMapper;
import com.ebaiyihui.family.doctor.server.mapper.PatientSignMapper;
import com.ebaiyihui.family.doctor.server.service.ImChatTemplate;
import com.ebaiyihui.family.doctor.server.service.PatientSignService;
import com.ebaiyihui.family.doctor.server.util.IDCardUtil;
import com.ebaiyihui.family.doctor.server.util.PageUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.imforward.client.vo.*;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @ClassName: PatientSignServiceImpl
 * @Author:yanliang
 * @Date:2024/3/13 14:14
 * @Description
 */
@Service
@Slf4j
public class PatientSignServiceImpl implements PatientSignService {

    @Autowired
    private IMSyncMsgClient imSyncMsgClient;

    @Autowired
    private ImApiFeignClient imApiFeignClient;

    @Autowired
    private DoctorInfofeignClient doctorCilent;

    @Autowired
    private PatientSignMapper patientSignMapper;

    @Autowired
    private PatientMapper patientMapper;

    @Autowired
    private ImChatTemplate imChatTemplate;


    @Override
    public BaseResponse<List<IMSingleMsgResultVO>> getAllMsgContent(IMQueryMsgReqVO reqVO) {
        log.info("同步会话消息入参" + JSON.toJSONString(reqVO));
        BaseResponse<List<IMSingleMsgResultVO>> listBaseResponse = imSyncMsgClient.queryImMsg(reqVO);
        log.info("同步会话消息出参" + JSON.toJSONString(listBaseResponse));
        if (!listBaseResponse.isSuccess()) {
            log.info("imSyncMsgClient.queryImMsg: " + listBaseResponse.toString());
            return BaseResponse.error(listBaseResponse.getMsg());
        }

        if (listBaseResponse.getData() == null) {
            return BaseResponse.success(new ArrayList<>());
        }
        List<IMSingleMsgResultVO> imMsgResultVOList = listBaseResponse.getData();
        for (IMSingleMsgResultVO imSingleMsgResultVO : imMsgResultVOList) {
            try {
                JSONObject jsonObject =
                        JSONObject.parseObject(imSingleMsgResultVO.getMsgContent());
                if (jsonObject.get("msgId") != null && StringUtils.isNotEmpty(jsonObject.get("msgId").toString())) {
                    String msgId = jsonObject.get("msgId").toString();
                    imSingleMsgResultVO.setMsgId(msgId);
                }
            } catch (Exception e) {
                continue;
            }

        }
        log.info("查询到结果为:{}" + imMsgResultVOList.toString());

        return BaseResponse.success(imMsgResultVOList);
    }

    @Override
    public BaseResponse<ImInfoResVo> queryImInfo(String admId) {
        QueryWrapper<PatientSignEntity> wrapper = new QueryWrapper<>();
        PatientSignEntity patientSign = new PatientSignEntity();
        patientSign.setAdmId(admId);
        wrapper.setEntity(patientSign);
        PatientSignEntity patientSignEntity = patientSignMapper.selectOne(wrapper);

        IMQueryTargetSdkAccountRspVO docImAccount = imChatTemplate.queryImAccount(admId, ImConstants.IM_DOC_ACCOUNT_NUM, String.valueOf(patientSignEntity.getDoctorId()));
        IMQueryTargetSdkAccountRspVO patImAccount = imChatTemplate.queryImAccount(admId, ImConstants.IM_PAT_ACCOUNT_NUM, String.valueOf(patientSignEntity.getDoctorId()));

        IMQueryUserLoginReqVO reqVO = new IMQueryUserLoginReqVO();
        reqVO.setAppCode(ImConstants.IM_PAT_ACCOUNT_NUM);
        reqVO.setUserId(patientSignEntity.getPatientUserId());
        BaseResponse<IMQueryUserLoginRspVO> imSysResult = imApiFeignClient.queryUserLogin(reqVO);
        log.info("获取IM登录信息:{}", imSysResult);

        IMQueryMsgReqVO imQueryMsgReqVO = new IMQueryMsgReqVO();
        imQueryMsgReqVO.setAppCode(IMInformConstants.PATIENT_APPLICATION_CODE);
        imQueryMsgReqVO.setUserId(patientSignEntity.getPatientUserId());
        imQueryMsgReqVO.setBusinessCode(IMInformConstants.IM_SYSTEM_BUSINESS_CODE);
        imQueryMsgReqVO.setMsgType("1");
        imQueryMsgReqVO.setPageSize(999);
        imQueryMsgReqVO.setSortOrder("ASC");


        ImInfoResVo resVo = ImInfoResVo.builder()
                .docImAccount(docImAccount.getSdkAccount())
                .patImAccount(patImAccount.getSdkAccount())
                .roomNum(docImAccount.getRoomNum())
                .sig(imSysResult.getData().getSig())
                .doctorName(patientSignEntity.getDoctorName())
                .build();
        // 患者信息
        resVo.setPatientName(patientSignEntity.getPatientName());
        resVo.setPatientPortrait("");

        QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
        queryPersonnelInfoReq.setDoctorId(String.valueOf(patientSignEntity.getDoctorId()));
        BaseResponse<PersonnelInfo> res = doctorCilent.queryPersonnelInfo(queryPersonnelInfoReq);
        if (res.isSuccess()) {
            resVo.setDoctorPortrait(res.getData().getPortrait());
            resVo.setDeptId(String.valueOf(res.getData().getDeptId()));
        }

        List<String> appointmentId = new ArrayList<>();
        appointmentId.add(admId);
        imQueryMsgReqVO.setAppointmentId(appointmentId);

        BaseResponse<List<IMSingleMsgResultVO>> allMsgContent = getAllMsgContent(imQueryMsgReqVO);

        if (allMsgContent.isSuccess() && Objects.nonNull(allMsgContent.getData())) {
            List<IMMsgResultVo> imMsgResultVos = new ArrayList<>();
            List<IMSingleMsgResultVO> msgResultVOS = allMsgContent.getData();
            msgResultVOS.forEach(
                    msgResultVO -> {
                        IMMsgResultVo imMsgResultVo = new IMMsgResultVo();
                        BeanUtils.copyProperties(msgResultVO, imMsgResultVo);
                        imMsgResultVos.add(imMsgResultVo);
                    }

            );
            resVo.setIMMsgVo(imMsgResultVos);
        }

        return BaseResponse.success(resVo);
    }

    @Override
    public BaseResponse<PageUtil<ImInfoListResVo>> queryImInfoList(ImInfoListDocReqDTO param) {
        param.setPageNum((param.getPageNum() - 1) * param.getPageSize());
        List<ImInfoListResVo> records = patientSignMapper.queryImInfoList(param);
        //根据患者id分组
        Map<String, List<ImInfoListResVo>> collect =
                records.stream().collect(Collectors.groupingBy(ImInfoListResVo::getPatientId));


        List<ImInfoListResVo> resVo = new ArrayList<>();
        for (String key : collect.keySet()) {
            List<ImInfoListResVo> zkFbImInfoListResVos = collect.get(key);
            List<String> admIds = zkFbImInfoListResVos.stream().map(ImInfoListResVo::getAdmId).collect(Collectors.toList());
            ImInfoListResVo record = zkFbImInfoListResVos.get(0);
            Integer age = IDCardUtil.getAge(record.getCredNo());
            Integer gender = IDCardUtil.getGenderForInteger(record.getCredNo());

            record.setAge(age);
            record.setGender(gender);

            String statusDesc = StatusEnum.getDesc(record.getStatus());
            record.setStatusDesc(statusDesc);

            record.setStatus(record.getStatus());
            record.setAdmIds(admIds);
            resVo.add(record);
        }

        resVo = resVo.stream().sorted(Comparator.comparing(ImInfoListResVo::getUpdateTime).reversed()).collect(Collectors.toList());


        PageUtil pageUtil = new PageUtil();
        pageUtil.setList(resVo);
//        pageUtil.setTotal(total);

        return BaseResponse.success(pageUtil);
    }

    @Override
    public BaseResponse<ImInfoDetailDocResVo> queryImInfoDetail(ImInfoDetailDocReqDTO param) {
        ImInfoDetailDocResVo resVo = new ImInfoDetailDocResVo();

        //订单信息
        QueryWrapper<PatientSignEntity> psWrapper = new QueryWrapper<>();
        PatientSignEntity patientSign = new PatientSignEntity();
        patientSign.setAdmId(param.getAdmissionId());
        psWrapper.setEntity(patientSign);
        PatientSignEntity patientSignEntity = patientSignMapper.selectOne(psWrapper);
        if (Objects.isNull(patientSignEntity) || Objects.isNull(patientSignEntity)) {
            return BaseResponse.error("未查询到签约医生信息");
        }
        resVo.setDoctorId(String.valueOf(patientSignEntity.getDoctorId()));
        resVo.setAdmId(patientSignEntity.getAdmId());
        resVo.setStatus(patientSignEntity.getStatus());
        resVo.setDeptId(patientSignEntity.getDeptId().toString());
        resVo.setDeptName(patientSignEntity.getDeptName());
        resVo.setSignEndTime(patientSignEntity.getSignEndTime());

        //患者信息
        PatientEntity patientEntity = patientMapper.selectById(patientSignEntity.getPatientId());
        PatientInfoVo patientInfoVo = new PatientInfoVo();
        patientInfoVo.setPatientName(patientEntity.getPatientName());
        patientInfoVo.setPatientId(patientEntity.getId());
        patientInfoVo.setGender(IDCardUtil.getGenderForInteger(patientEntity.getCredNo()));
        patientInfoVo.setAge(IDCardUtil.getAge(patientEntity.getCredNo()));
        patientInfoVo.setCredNo(patientEntity.getCredNo());
        patientInfoVo.setPatientUserId(patientSignEntity.getPatientUserId());
        patientInfoVo.setPortrait("");
        resVo.setPatientInfo(patientInfoVo);

        // 获取医生基本信息
        QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
        queryPersonnelInfoReq.setDoctorId(String.valueOf(patientSignEntity.getDoctorId()));
        BaseResponse<PersonnelInfo> res =
                doctorCilent.queryPersonnelInfo(queryPersonnelInfoReq);
        if (null != res && res.isSuccess()) {
            resVo.setDoctorName(res.getData().getDoctorName());
            resVo.setDoctorPortrait(res.getData().getPortrait());
        }

        return BaseResponse.success(resVo);
    }

    @Override
    public BaseResponse<ImAccountVo> queryImAccount(ImAccountReqDTO param) {
        // 转换imAppCode
        if (ImConstants.IM_DOC_ACCOUNT_NUM.equals(param.getImAppCode())) {
            param.setImAppCode(ImConstants.IM_PAT_ACCOUNT_NUM);
        } else if (ImConstants.IM_PAT_ACCOUNT_NUM.equals(param.getImAppCode())) {
            param.setImAppCode(ImConstants.IM_DOC_ACCOUNT_NUM);
        }
        String admissionId = param.getAdmissionId();
        QueryWrapper<PatientSignEntity> psWrapper = new QueryWrapper<>();
        PatientSignEntity patientSign = new PatientSignEntity();
        patientSign.setAdmId(param.getAdmissionId());
        psWrapper.setEntity(patientSign);
        PatientSignEntity patientSignEntity = patientSignMapper.selectOne(psWrapper);

        if (StringUtils.isEmpty(param.getDoctorId())) {
            param.setDoctorId(String.valueOf(patientSignEntity.getDoctorId()));
        }
        return BaseResponse.success(getImAccounts(patientSignEntity, admissionId, param.getImAppCode(), param.getDoctorId()));
    }

    @Override
    public BaseResponse<IMQueryUserLoginRspVO> querySdkLogin(IMQueryUserLoginReqVO reqVO) {
        BaseResponse<IMQueryUserLoginRspVO> imSysResult = imApiFeignClient.queryUserLogin(reqVO);

        if (imSysResult == null) {
            return BaseResponse.error(imSysResult.getMsg());
        }
        if (BaseResponse.DEFAULT_ERROR_CODE.equals(imSysResult.getCode())) {
            return BaseResponse.error(imSysResult.getMsg());
        }

        return BaseResponse.success(imSysResult.getData());
    }

    @Override
    public List<PatientSignEntity> selectList(PatientSignEntity patientSignEntity) {
        QueryWrapper<PatientSignEntity> listWrapper = new QueryWrapper<>();
        patientSignEntity.setStatus(StatusEnum.IN_CONSULTATION.getValue());
        patientSignEntity.setSignStatus(SignStatus.SIGNED.getValue());
        listWrapper.setEntity(patientSignEntity);
        List<PatientSignEntity> patientSignEntities = patientSignMapper.selectList(listWrapper);
        return patientSignEntities;
    }

    @Override
    public PatientSignEntity getOneByPhone(String phone) {
        QueryWrapper<PatientSignEntity> psWrapper = new QueryWrapper<>();
        PatientSignEntity patientSign = new PatientSignEntity();
        patientSign.setPatientPhone(phone);
        psWrapper.setEntity(patientSign);
        psWrapper.orderByDesc("createTime");
        psWrapper.last("limit 1");
        PatientSignEntity pse = patientSignMapper.selectOne(psWrapper);
        return pse;
    }

    @Override
    public int updateById(PatientSignEntity patientSignEntity) {
        return patientSignMapper.updateById(patientSignEntity);
    }

    public ImAccountVo getImAccounts(PatientSignEntity patientSignEntity, String admId, String imAppCode, String doctorId) {

        ImAccountVo admission = new ImAccountVo();
        IMQueryTargetSdkAccountRspVO imAccountRes = imChatTemplate.queryImAccount(admId, imAppCode, doctorId);
        if (imAccountRes == null) {
            //查寻Im账户为空，直接新创建，在重新查
            imChatTemplate.createImSession(patientSignEntity);
            IMQueryTargetSdkAccountRspVO imAccountRes1 = imChatTemplate.queryImAccount(admId, imAppCode, doctorId);
            if (imAccountRes1 == null) {
                log.info("IM ERROR 没有查询到IM账户-admId:{}", admId);
                return admission;
            }
            log.info("imAccountRes1:{}" + JSON.toJSONString(imAccountRes1));
            if (ImConstants.IM_DOC_ACCOUNT_NUM.equals(imAppCode)) {
                admission.setDocImAccount(imAccountRes1.getSdkAccount());
            } else if (ImConstants.IM_PAT_ACCOUNT_NUM.equals(imAppCode)) {
                admission.setPatImAccount(imAccountRes1.getSdkAccount());
            }
            // 设置房间号
            admission.setRoomNum(imAccountRes1.getRoomNum());
            return admission;
        }
        log.info("imAccountRes:{}" + JSON.toJSONString(imAccountRes));
        if (ImConstants.IM_DOC_ACCOUNT_NUM.equals(imAppCode)) {
            admission.setDocImAccount(imAccountRes.getSdkAccount());
        } else if (ImConstants.IM_PAT_ACCOUNT_NUM.equals(imAppCode)) {
            admission.setPatImAccount(imAccountRes.getSdkAccount());
        }
        // 设置房间号
        admission.setRoomNum(imAccountRes.getRoomNum());
        return admission;
    }

}
