package com.ebaiyihui.family.doctor.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.doctoruser.api.pojo.base.dto.doctor.QueryPersonnelInfoReq;
import com.doctoruser.api.pojo.base.vo.doctor.PersonnelInfo;
import com.ebaiyihui.family.doctor.common.bo.DoctorInfo;
import com.ebaiyihui.family.doctor.common.dto.*;
import com.ebaiyihui.family.doctor.common.vo.*;
import com.ebaiyihui.family.doctor.server.common.enums.WhetherEnum;
import com.ebaiyihui.family.doctor.server.entity.ScheduleRecordEntity;
import com.ebaiyihui.family.doctor.server.feign.DoctorInfofeignClient;
import com.ebaiyihui.family.doctor.server.mapper.ScheduleRecordMapper;
import com.ebaiyihui.family.doctor.server.service.ScheduleRecordService;
import com.ebaiyihui.family.doctor.server.util.DateUtils;
import com.ebaiyihui.framework.response.BaseResponse;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @ClassName: ScheduleRecordServiceImpl
 * @Author:yanliang
 * @Date:2024/3/14 16:22
 * @Description
 */
@Service
@Slf4j
public class ScheduleRecordServiceImpl implements ScheduleRecordService {

    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;

    @Autowired
    private DoctorInfofeignClient doctorCilent;

    @Override
    public BaseResponse<String> insert(InsertScheduleRecordReqDTO record) {
        String currentDate = DateUtils.getCurrentDateSimpleToString();
        Date dateNow = null;
        Date startRes = null;
        Date endRes = null;
        try {
            dateNow = DateUtils.strToDate(currentDate, "yyyy-MM-dd");
            startRes = DateUtils.strToDate(record.getScheduleDate(), "yyyy-MM-dd");
            endRes = DateUtils.strToDate(record.getScheduleDateEnd(), "yyyy-MM-dd");
        } catch (ParseException e) {
            e.printStackTrace();
        }
        if (dateNow.after(startRes)) {
            return BaseResponse.error("新增排班日期需大于等于当前日期");
        }
        List<DoctorInfoForScheduleDTO> doctorInfoForScheduleList = record.getDoctorInfoForSchedule();
        List<ScheduleRangeAndTimeDTO> scheduleRangeTimeList = record.getScheduleRangeAndTime();

        List<String> dates = new ArrayList<>();
        List<String> dateReq = DateUtils.getDateRange(startRes, endRes);
        log.info("dateReq{}", JSON.toJSONString(dateReq));
        List<String> allDates = DateUtils.getOneDayNextWeek(dateReq, 3);
        log.info("allDates{}", JSON.toJSONString(allDates));
        if (WhetherEnum.ALLOW.getValue().equals(record.getIsCycleSchedule())) {
            dates.addAll(allDates);
        } else {
            dates.addAll(dateReq);
        }
        log.info("dates{}", JSON.toJSONString(dates));

        for (DoctorInfoForScheduleDTO doctorInfo : doctorInfoForScheduleList) {
            //查出此科室此医生 此时段 所有排班日期
            QueryWrapper<ScheduleRecordEntity> scheduleRecordWrapper = new QueryWrapper<>();
            ScheduleRecordEntity scheduleRecordEntity = new ScheduleRecordEntity();
            scheduleRecordEntity.setDoctorId(doctorInfo.getDoctorId());
            scheduleRecordEntity.setHospitalId(record.getHospitalId());
            scheduleRecordEntity.setDeptId(doctorInfo.getDeptId());
            scheduleRecordEntity.setStatus(WhetherEnum.ALLOW.getValue());
            scheduleRecordEntity.setServType(record.getServType());
            for (String oneDay : dates) {
                scheduleRecordEntity.setScheduleDate(DateUtils.strToDateNoTry(oneDay));
                scheduleRecordWrapper.setEntity(scheduleRecordEntity);
                log.info("医生某科室某天有排班的入参:" + scheduleRecordEntity);
                List<ScheduleRecordEntity> list = scheduleRecordMapper.selectList(scheduleRecordWrapper);

                if (CollectionUtils.isEmpty(list)) {
                    continue;
                }
                log.info("list{}", list.toString());

                for (ScheduleRangeAndTimeDTO rangeReq : scheduleRangeTimeList) {
                    for (ScheduleRecordEntity rangeRes : list) {
                        Boolean aBoolean = DateUtils.rangeCompare(DateUtils.strToDateNoTryForMinute(rangeReq.getStartTime()),
                                DateUtils.strToDateNoTryForMinute(rangeReq.getEndTime()),
                                DateUtils.strToDateNoTryForMinute(rangeRes.getStartTime()),
                                DateUtils.strToDateNoTryForMinute(rangeRes.getEndTime()));
                        if (aBoolean) {
                            return BaseResponse.error("排班时段与已添加排班时间冲突，请重新设置");
                        }
                    }
                }

            }
        }

        for (DoctorInfoForScheduleDTO doctorInfo : doctorInfoForScheduleList) {
            for (String oneDay : dates) {
                scheduleRangeTimeList.stream().forEach(rangeVo -> {
                    getInsertSchedule(record, doctorInfo, rangeVo, oneDay);
                });
            }
        }

        return BaseResponse.success("新增排班成功");
    }

    @Override
    public BaseResponse<List<ResponseGetScheduleForWeekVo>> getScheduleForWeek(RequestGetScheduleForWeekDTO requestGetScheduleForWeekDTO) {
        Date intStartDate = DateUtils.dateToDateAsFormat(DateUtils.getBeginDayOfWeek());

        Date intEndDate = DateUtils.dateToDateAsFormat(DateUtils.getEndDayOfWeek());

        Integer week = requestGetScheduleForWeekDTO.getWeek();

        Date startDate = null;
        Date endDate = null;

        startDate = DateUtils.getDateAfter(intStartDate, 7 * week);
        endDate = DateUtils.getDateAfter(intEndDate, 7 * week);

        QueryWrapper<ScheduleRecordEntity> wrapper = new QueryWrapper();

        ScheduleRecordEntity entity = new ScheduleRecordEntity();
        entity.setDoctorId(requestGetScheduleForWeekDTO.getDoctorId());
        entity.setDeptId(String.valueOf(requestGetScheduleForWeekDTO.getDeptId()));
        entity.setHospitalId(String.valueOf(requestGetScheduleForWeekDTO.getHospitalId()));
        wrapper.setEntity(entity);
        wrapper.between("schedule_date", startDate, endDate);

        List<ScheduleRecordEntity> recordEntityList = scheduleRecordMapper.selectList(wrapper);
        log.info("查询排班结果{}", recordEntityList.toString());

        List<ResponseGetScheduleForWeekVo> list = new ArrayList<>();

        for (int i = 0; i < 7; i++) {
            ResponseGetScheduleForWeekVo scheduleForWeekVo = new ResponseGetScheduleForWeekVo();
            Date weekDay = DateUtils.getDateAfter(startDate, i);
            scheduleForWeekVo.setScheduleDate(weekDay);
            List<ScheduleOfDayVo> scheduleOfDayVoList = new ArrayList<>();

            for (int j = 1; j <= 3; j++) {
                ScheduleOfDayVo scheduleOfDayVo = new ScheduleOfDayVo();
                QueryWrapper<ScheduleRecordEntity> queryWrapper = new QueryWrapper<>();
                ScheduleRecordEntity timeIntervalEntity = new ScheduleRecordEntity();
                timeIntervalEntity.setHospitalId(String.valueOf(requestGetScheduleForWeekDTO.getHospitalId()));
                timeIntervalEntity.setDoctorId(requestGetScheduleForWeekDTO.getDoctorId());
                timeIntervalEntity.setDeptId(String.valueOf(requestGetScheduleForWeekDTO.getDeptId()));
                timeIntervalEntity.setScheduleDate(weekDay);
                timeIntervalEntity.setScheduleRange(j);
                queryWrapper.setEntity(timeIntervalEntity);
                ScheduleRecordEntity scheduleTimeIntervalEntity = scheduleRecordMapper.selectOne(queryWrapper);
                ScheduleTimeSaveListVo saveListVo = new ScheduleTimeSaveListVo();
                if (null != scheduleTimeIntervalEntity) {
                    BeanUtils.copyProperties(scheduleTimeIntervalEntity, saveListVo);

                }
                scheduleOfDayVo.setScheduleTimeSaveListVo(saveListVo);

//                List<ScheduleRecordVo> scheduleRecordVoList = new ArrayList<>();
//                if (!recordEntityList.isEmpty()) {
//                    for (ScheduleRecordEntity scheduleRecordEntity : recordEntityList) {
//                        if (DateUtils.dateToSimpleString(scheduleRecordEntity.getScheduleDate()).equals(DateUtils.dateToSimpleString(weekDay)) && scheduleRecordEntity.getScheduleRange().equals(j)) {
//                            ScheduleRecordVo scheduleRecordVo = new ScheduleRecordVo();
//                            BeanUtils.copyProperties(scheduleRecordEntity, scheduleRecordVo);
//                            QueryWrapper configQuery = new QueryWrapper();
//
//                            ServiceConfigEntity configEntity = new ServiceConfigEntity();
//                            configEntity.setOrganId(String.valueOf(requestGetScheduleForWeekDTO.getHospitalId()));
//                            configEntity.setDoctorId(scheduleRecordEntity.getDoctorId());
//                            configEntity.setDeptId(Long.parseLong(scheduleRecordEntity.getDeptId()));
//                            configQuery.setEntity(configEntity);
//                            configQuery.last("limit 1");
//                            scheduleRecordVoList.add(scheduleRecordVo);
//                        }
//                    }
//                }
//                scheduleOfDayVo.setRecordVoList(scheduleRecordVoList);
                scheduleOfDayVoList.add(scheduleOfDayVo);
            }
            scheduleForWeekVo.setScheduleOfDayVoList(scheduleOfDayVoList);
            list.add(scheduleForWeekVo);
        }
        return BaseResponse.success(list);
    }

    @Override
    public BaseResponse<List<ScheduleForWeekResVo>> scheduleForWeekNew(ScheduleForWeekReqDTO scheduleForWeekReqDTO) {
        //停诊的不展示
        Date intStartDate = DateUtils.dateToDateAsFormat(DateUtils.getBeginDayOfWeek());
        Date intEndDate = DateUtils.dateToDateAsFormat(DateUtils.getEndDayOfWeek());
        Integer week = scheduleForWeekReqDTO.getWeek();
        Date startDate;
        Date endDate;
        startDate = DateUtils.getDateAfter(intStartDate, 7 * week);
        endDate = DateUtils.getDateAfter(intEndDate, 7 * week);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<ScheduleForWeekResVo> list = new ArrayList<>();
        //根据医院 业务 找出 非停诊的 当前周的 医生排班列表  或加 医生姓名(用于管理端医生姓名搜索)
        List<ScheduleRecordEntity> scheduleRecordEList = getScheduleRecordEntities(scheduleForWeekReqDTO);
        if (CollectionUtils.isEmpty(scheduleRecordEList)) {
            list = noScheduleRes(startDate);
            return BaseResponse.success(list);
        }
        log.info("查询排班结果{}", scheduleRecordEList.size());

        //过滤出 在排班日期范围内的 数据
        ArrayList<ScheduleRecordEntity> recordEntityList = new ArrayList<>();
        for (ScheduleRecordEntity scheduleRecord : scheduleRecordEList) {
            boolean overlap = DateUtils.overlap(scheduleRecord.getScheduleDate(), scheduleRecord.getScheduleDate(), startDate, endDate);
            if (overlap) {
                recordEntityList.add(scheduleRecord);
            }
        }
        if (CollectionUtils.isEmpty(recordEntityList)) {
            log.info("此时段无排班");
            list = noScheduleRes(startDate);
            return BaseResponse.success(list);
        }
        log.info("scheduleRecordfilterList:" + recordEntityList.toString());

        int i = 0;
        for (i = 0; i < 7; i++) {
            ScheduleForWeekResVo scheduleTimeRes = new ScheduleForWeekResVo();
            Date dateAfter = DateUtils.getDateAfter(startDate, i);
            String format = simpleDateFormat.format(dateAfter);
            log.info("第几天:" + format);
            scheduleTimeRes.setScheduleTime(format);
            ArrayList<ScheduleRecordEntity> scheduleOneDayList = new ArrayList<>();
            recordEntityList.stream().forEach(record -> {
                boolean overlap = DateUtils.overlap(record.getScheduleDate(), record.getScheduleDate(), dateAfter, dateAfter);
                if (overlap) {
                    scheduleOneDayList.add(record);
                }
            });
            if (CollectionUtils.isEmpty(scheduleOneDayList)) {
                scheduleTimeRes.setScheduleInfos(new ArrayList<>());
                list.add(scheduleTimeRes);
                continue;
            }
            log.info("某天的排班{}", scheduleOneDayList.toString());

            //根据医生分组
            Map<String, List<ScheduleRecordEntity>> collect =
                    scheduleOneDayList.stream().collect(Collectors.groupingBy(ScheduleRecordEntity::getDoctorId));
            List<ScheduleInfoVo> scheduleInfos = new ArrayList<>();
            for (String key : collect.keySet()) {
                List<ScheduleRecordEntity> scheduleRecordEntities = collect.get(key);
                //根据科室分组
                Map<String, List<ScheduleRecordEntity>> collectDept =
                        scheduleRecordEntities.stream().collect(Collectors.groupingBy(ScheduleRecordEntity::getDeptId));
                for (String keyDept : collectDept.keySet()) {
                    ScheduleInfoVo scheduleInfo = new ScheduleInfoVo();
                    List<ScheduleRecordEntity> scheduleRecord = collectDept.get(keyDept);
                    DoctorInfo doctorInfo = new DoctorInfo();
                    log.info("医生信息入参{}", JSON.toJSONString(scheduleRecord));

                    QueryPersonnelInfoReq queryPersonnelInfoReq = new QueryPersonnelInfoReq();
                    queryPersonnelInfoReq.setDoctorId(scheduleRecord.get(0).getDoctorId());
                    BaseResponse<PersonnelInfo> response = doctorCilent.queryPersonnelInfo(queryPersonnelInfoReq);
                    doctorInfo.setDeptId(keyDept);
                    doctorInfo.setDeptName(scheduleRecord.get(0).getDeptName());
                    doctorInfo.setDoctorId(scheduleRecord.get(0).getDoctorId());
                    doctorInfo.setDoctorName(scheduleRecord.get(0).getDoctorName());
                    doctorInfo.setDoctorProfession(response.getData().getTitle());
                    doctorInfo.setDoctorPortrait(response.getData().getPortrait());

                    ArrayList<ScheduleRangeAndCountVo> scheduleRangeAndCounts = new ArrayList<>();
                    List<ScheduleRecordEntity> scheduleRecordCountEntities = getScheduleRecordEntities(scheduleForWeekReqDTO, format, doctorInfo);
                    scheduleRecordCountEntities.sort(Comparator.comparing(ScheduleRecordEntity::getStartTime));
                    scheduleRecordCountEntities.stream().forEach(scheduleRecordCount -> {
                        ScheduleRangeAndCountVo scheduleRangeAndCount = new ScheduleRangeAndCountVo();
                        BeanUtils.copyProperties(scheduleRecordCount, scheduleRangeAndCount);
                        scheduleRangeAndCounts.add(scheduleRangeAndCount);
                    });
                    scheduleRecordCountEntities.sort(Comparator.comparing(ScheduleRecordEntity::getCreateTime));
                    BeanUtils.copyProperties(doctorInfo, scheduleInfo);
                    scheduleInfo.setCreateEarliestTime(scheduleRecordCountEntities.get(0).getCreateTime());
                    scheduleInfo.setScheduleRangeAndCountList(scheduleRangeAndCounts);
                    scheduleInfos.add(scheduleInfo);
                    scheduleInfos.sort(Comparator.comparing(ScheduleInfoVo::getCreateEarliestTime).reversed());
                    scheduleTimeRes.setScheduleInfos(scheduleInfos);
                }
            }
            list.add(scheduleTimeRes);
            log.info("list{}", list.toString());
        }
        return BaseResponse.success(list);
    }

    private void getInsertSchedule(InsertScheduleRecordReqDTO record, DoctorInfoForScheduleDTO doctorInfo, ScheduleRangeAndTimeDTO rangeRes, String s) {
        ScheduleRecordEntity schedule = new ScheduleRecordEntity();
        BeanUtils.copyProperties(record, schedule);
        BeanUtils.copyProperties(doctorInfo, schedule);
        BeanUtils.copyProperties(rangeRes, schedule);
        schedule.setAvailableCount(rangeRes.getTotalCount());
        Date date = null;
        try {
            date = DateUtils.strToDate(s, "yyyy-MM-dd");
        } catch (ParseException e) {
            e.printStackTrace();
        }
        schedule.setScheduleDate(date);
        log.info("排班新增入参:" + schedule.toString());
        scheduleRecordMapper.insert(schedule);
    }

    private ArrayList<ScheduleForWeekResVo> noScheduleRes(Date startDate) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<ScheduleForWeekResVo> list = new ArrayList<>();
        int i;
        for (i = 0; i < 7; i++) {
            ScheduleForWeekResVo scheduleTimeRes = new ScheduleForWeekResVo();
            Date dateAfter = DateUtils.getDateAfter(startDate, i);
            String format = simpleDateFormat.format(dateAfter);
            log.info("第几天:" + format);
            scheduleTimeRes.setScheduleTime(format);
            scheduleTimeRes.setScheduleInfos(new ArrayList<>());
            list.add(scheduleTimeRes);
        }
        return list;
    }

    private List<ScheduleRecordEntity> getScheduleRecordEntities(ScheduleForWeekReqDTO scheduleForWeekReqDTO, String format, DoctorInfo doctorInfo) {
        QueryWrapper<ScheduleRecordEntity> queryWrapper = new QueryWrapper<>();
        ScheduleRecordEntity scheduleRecordCountEntity = new ScheduleRecordEntity();
        scheduleRecordCountEntity.setHospitalId(scheduleForWeekReqDTO.getHospitalId().toString());
        scheduleRecordCountEntity.setDeptId(doctorInfo.getDeptId());
        scheduleRecordCountEntity.setDoctorId(doctorInfo.getDoctorId());
        try {
            scheduleRecordCountEntity.setScheduleDate(DateUtils.strToDate(format, "yyyy-MM-dd"));
        } catch (ParseException e) {
            e.printStackTrace();
        }
        scheduleRecordCountEntity.setStatus(WhetherEnum.ALLOW.getValue());
        scheduleRecordCountEntity.setServType(scheduleForWeekReqDTO.getServType());
        queryWrapper.setEntity(scheduleRecordCountEntity);
        return scheduleRecordMapper.selectList(queryWrapper);
    }

    private List<ScheduleRecordEntity> getScheduleRecordEntities(ScheduleForWeekReqDTO scheduleForWeekReqDTO) {
        QueryWrapper<ScheduleRecordEntity> wrapper = new QueryWrapper();
        ScheduleRecordEntity entity = new ScheduleRecordEntity();
        entity.setHospitalId(JSON.toJSONString(scheduleForWeekReqDTO.getHospitalId()));
        entity.setServType(scheduleForWeekReqDTO.getServType());
        entity.setStatus(WhetherEnum.ALLOW.getValue());
        wrapper.setEntity(entity);
        wrapper.like(StringUtils.isNotEmpty(scheduleForWeekReqDTO.getDoctorName()), "doctor_name", scheduleForWeekReqDTO.getDoctorName());
        log.info("查询入参:" + entity.toString());
        return scheduleRecordMapper.selectList(wrapper);
    }
}
