package com.ebaiyihui.family.doctor.server.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.family.doctor.common.dto.RequestGetDoctorOfficeStatusDTO;
import com.ebaiyihui.family.doctor.common.dto.RequestServiceConfigDTO;
import com.ebaiyihui.family.doctor.common.vo.RequestOnlineOrOfflineVo;
import com.ebaiyihui.family.doctor.server.entity.ServiceConfigEntity;
import com.ebaiyihui.family.doctor.server.exception.BusinessException;
import com.ebaiyihui.family.doctor.server.mapper.ServiceConfigMapper;
import com.ebaiyihui.family.doctor.server.service.ServiceConfigService;
import com.ebaiyihui.framework.response.BaseResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @ClassName: ServiceConfigServiceImpl
 * @Author:yanliang
 * @Date:2024/3/12 09:41
 * @Description
 */
@Service
@Slf4j
public class ServiceConfigServiceImpl implements ServiceConfigService {

    @Autowired
    private ServiceConfigMapper serviceConfigMapper;

    @Override
    public RequestOnlineOrOfflineVo getDoctorOfficeStatus(RequestGetDoctorOfficeStatusDTO requestGetDoctorOfficeStatusDTO) {
        QueryWrapper<ServiceConfigEntity> queryWrapper = new QueryWrapper<>();
        ServiceConfigEntity wrapperEntity = new ServiceConfigEntity();
        wrapperEntity.setOrganId(requestGetDoctorOfficeStatusDTO.getHospitalId());
        wrapperEntity.setAppCode(requestGetDoctorOfficeStatusDTO.getAppCode());
        wrapperEntity.setDoctorId(requestGetDoctorOfficeStatusDTO.getDoctorId());
        wrapperEntity.setStatus(1);
        queryWrapper.setEntity(wrapperEntity);
        queryWrapper.last("limit 1");
        ServiceConfigEntity serviceConfigEntity = serviceConfigMapper.selectOne(queryWrapper);

        if (null == serviceConfigEntity) {
            throw new BusinessException("当前医生未开通家庭医生服务或数据不同步！");
        }

        RequestOnlineOrOfflineVo requestOnlineOrOfflineVo = new RequestOnlineOrOfflineVo();
        requestOnlineOrOfflineVo.setAppCode(serviceConfigEntity.getAppCode());
        requestOnlineOrOfflineVo.setDoctorId(serviceConfigEntity.getDoctorId());
        requestOnlineOrOfflineVo.setHospitalId(serviceConfigEntity.getOrganId());
        requestOnlineOrOfflineVo.setDeptId(String.valueOf(serviceConfigEntity.getDeptId()));
        requestOnlineOrOfflineVo.setOfficeStatus(serviceConfigEntity.getOfficeStatus());

        return requestOnlineOrOfflineVo;
    }

    @Override
    public RequestOnlineOrOfflineVo officeOnlineOrOffline(RequestOnlineOrOfflineVo requestOnlineOrOfflineVo) {
        QueryWrapper<ServiceConfigEntity> queryWrapper = new QueryWrapper<>();
        ServiceConfigEntity wrapperEntity = new ServiceConfigEntity();
        wrapperEntity.setOrganId(requestOnlineOrOfflineVo.getHospitalId());
        wrapperEntity.setAppCode(requestOnlineOrOfflineVo.getAppCode());
        wrapperEntity.setDeptId(Long.valueOf(requestOnlineOrOfflineVo.getDeptId()));
        wrapperEntity.setDoctorId(requestOnlineOrOfflineVo.getDoctorId());
        queryWrapper.setEntity(wrapperEntity);
        queryWrapper.last("limit 1");
        ServiceConfigEntity serviceConfigEntity = serviceConfigMapper.selectOne(queryWrapper);

        if (null == serviceConfigEntity) {
            throw new BusinessException("未查询到该医生上下线配置信息！");
        }

        serviceConfigEntity.setOfficeStatus(requestOnlineOrOfflineVo.getOfficeStatus());
        int flag = serviceConfigMapper.updateById(serviceConfigEntity);
        if (flag <= 0) {
            if (requestOnlineOrOfflineVo.getOfficeStatus().equals(1)) {
                throw new BusinessException("上线失败");
            } else {
                throw new BusinessException("上线失败");
            }
        }

        return requestOnlineOrOfflineVo;
    }

    @Override
    public BaseResponse<Object> saveServiceInfo(RequestServiceConfigDTO serviceConfigDTO) {
        QueryWrapper<ServiceConfigEntity> queryWrapper = new QueryWrapper<>();
        ServiceConfigEntity wrapperEntity = new ServiceConfigEntity();
        wrapperEntity.setOrganId(serviceConfigDTO.getOrganId());
        wrapperEntity.setAppCode(serviceConfigDTO.getAppCode());
        wrapperEntity.setDeptId(serviceConfigDTO.getDeptId());
        wrapperEntity.setDoctorId(serviceConfigDTO.getDoctorId());
        wrapperEntity.setServiceCode(serviceConfigDTO.getServiceCode());
        queryWrapper.setEntity(wrapperEntity);
        queryWrapper.last("limit 1");
        ServiceConfigEntity serviceConfigEntity = serviceConfigMapper.selectOne(queryWrapper);
        ServiceConfigEntity entity = new ServiceConfigEntity();
        //没有找到具体的医生信息,新增
        if (null == serviceConfigEntity) {
            BeanUtils.copyProperties(serviceConfigDTO, entity);
            entity.setOfficeStatus(1);
            log.info("添加家庭医生服务信息entity: {}", entity);
            serviceConfigMapper.insert(entity);

            return BaseResponse.success("新增家庭医生服务信息成功");
        }
        //找到了医生信息,修改
        BeanUtils.copyProperties(serviceConfigDTO, entity);
        log.info("查询到服务信息id：" + serviceConfigEntity.getId());
        entity.setId(serviceConfigEntity.getId());
        entity.setStatus(serviceConfigDTO.getStatus());
        log.info("修改家庭医生服务信息entity: {}", entity);
        serviceConfigMapper.updateById(entity);

        return BaseResponse.success("修改家庭医生服务信息成功");
    }
}
