package com.ebaiyihui.family.doctor.server.task;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.family.doctor.server.common.enums.WhetherEnum;
import com.ebaiyihui.family.doctor.server.entity.ScheduleRecordEntity;
import com.ebaiyihui.family.doctor.server.mapper.ScheduleRecordMapper;
import com.ebaiyihui.family.doctor.server.util.DateUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @ClassName: TaskSchedule
 * @Author:yanliang
 * @Date:2024/3/20 17:29
 * @Description
 */
@Component
@Slf4j
public class ScheduleTask {

    private static final String MONDAY = "星期一";

    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;

    //    @Scheduled(cron = "0 0/2 * * * ?")
    @Scheduled(cron = "0 0 0 * * ?")
    public void regularTimeExport() {


        /*
         * 某天
         * 某业务
         *    某医生
         *       某科室 下的开通循环排班的数据
         *
         *       此条件下 第5周 开通排班 未停诊 的数据
         *
         *       对比这两个list 去掉重复 新增(不停诊 日期为第5周的当天)
         *
         *       定时任务时间修改
         *
         */
        String currentDateSimpleToString = DateUtils.getCurrentDateSimpleToString();
        log.info("当前时间{}", JSON.toJSONString(currentDateSimpleToString));
        String weekChinese = DateUtils.getWeekChinese(currentDateSimpleToString);
        log.info("当前时间是{}", JSON.toJSONString(weekChinese));
        if (!MONDAY.equals(weekChinese)) {
            return;
        }

        //周末
        String oneDayForWeekLast = DateUtils.getOneDayForWeekLast(currentDateSimpleToString);
        Date weekDateFirst = DateUtils.strToDateNoTry(currentDateSimpleToString);
        Date weekDateLast = DateUtils.strToDateNoTry(oneDayForWeekLast);

        List<String> dateRange = DateUtils.getDateRange(weekDateFirst, weekDateLast);
        log.info("一周的日期{}", JSON.toJSONString(dateRange));

        for (String schDate : dateRange) {
            QueryWrapper<ScheduleRecordEntity> schWapper = new QueryWrapper<>();
            ScheduleRecordEntity scheduleRecordEntity = new ScheduleRecordEntity();
            scheduleRecordEntity.setIsCycleSchedule(WhetherEnum.ALLOW.getValue());
            scheduleRecordEntity.setScheduleDate(DateUtils.strToDateNoTry(schDate));
            schWapper.setEntity(scheduleRecordEntity);
            log.info("某天开通循环排班列表入参{}", JSON.toJSONString(schWapper));
            List<ScheduleRecordEntity> list = scheduleRecordMapper.selectList(schWapper);
            log.info("某天开通循环排班列表出参{}", JSON.toJSONString(list));
            if (CollectionUtils.isEmpty(list)) {
                continue;
            }
            //根据业务分组
            Map<Integer, List<ScheduleRecordEntity>> servTypeCollect =
                    list.stream().collect(Collectors.groupingBy(ScheduleRecordEntity::getServType));
            for (Integer servType : servTypeCollect.keySet()) {
                List<ScheduleRecordEntity> servTypeList = servTypeCollect.get(servType);
                //根据医生分组
                Map<String, List<ScheduleRecordEntity>> doctorCollect =
                        servTypeList.stream().collect(Collectors.groupingBy(ScheduleRecordEntity::getDoctorId));
                for (String docId : doctorCollect.keySet()) {
                    List<ScheduleRecordEntity> scheduleDeptList = doctorCollect.get(docId);
                    //根据科室分组
                    Map<String, List<ScheduleRecordEntity>> deptCollect =
                            scheduleDeptList.stream().collect(Collectors.groupingBy(ScheduleRecordEntity::getDeptId));

                    for (String deptId : deptCollect.keySet()) {
                        //某天某医生某科室的所有排班
                        List<ScheduleRecordEntity> rangeList = deptCollect.get(deptId);

                        QueryWrapper<ScheduleRecordEntity> nextWrapper = new QueryWrapper<>();
                        ScheduleRecordEntity nextSchedule = new ScheduleRecordEntity();
                        nextSchedule.setStatus(WhetherEnum.ALLOW.getValue());
                        nextSchedule.setDoctorId(docId);
                        nextSchedule.setDeptId(deptId);
                        nextSchedule.setServType(servType);
                        nextSchedule.setScheduleDate(DateUtils.getNextWeek(schDate, 3));
                        nextWrapper.setEntity(nextSchedule);
                        log.info("第5周当天排班入参{}", JSON.toJSONString(schWapper));
                        List<ScheduleRecordEntity> nextScheList = scheduleRecordMapper.selectList(nextWrapper);
                        log.info("第5周当天排班出参{}", JSON.toJSONString(nextScheList));
                        if (CollectionUtils.isEmpty(nextScheList)) {
                            rangeList.stream().forEach(rangeVo -> {
                                ScheduleRecordEntity schedule = new ScheduleRecordEntity();
                                BeanUtils.copyProperties(rangeVo, schedule);
                                schedule.setStatus(WhetherEnum.ALLOW.getValue());
                                schedule.setScheduleDate(DateUtils.getNextWeek(schDate, 3));
//                                schedule.setAvailableCount(rangeVo.getTotalCount());
                                log.info("排班新增入参:" + schedule.toString());
                                scheduleRecordMapper.insert(schedule);
                            });
                            continue;
                        }
                        ArrayList<ScheduleRecordEntity> rangeSch = new ArrayList<>();
                        //如果第5周有排班 和当前对比 去除重复的时段
                        for (ScheduleRecordEntity rangeReq : rangeList) {
                            Boolean flag = false;
                            for (ScheduleRecordEntity rangeRes : nextScheList) {
                                Boolean aBoolean = DateUtils.rangeCompare(DateUtils.strToDateNoTryForMinute(rangeReq.getStartTime()),
                                        DateUtils.strToDateNoTryForMinute(rangeReq.getEndTime()),
                                        DateUtils.strToDateNoTryForMinute(rangeRes.getStartTime()),
                                        DateUtils.strToDateNoTryForMinute(rangeRes.getEndTime()));
                                if (aBoolean) {
                                    flag = true;
                                    break;
                                }
                            }
                            if (flag) {
                                continue;
                            } else {
                                rangeSch.add(rangeReq);
                            }
                        }

                        if (CollectionUtils.isEmpty(rangeSch)) {
                            continue;
                        }
                        log.info("rangeList{}", JSON.toJSONString(rangeSch));
                        rangeSch.stream().forEach(rangeVo -> {
                            ScheduleRecordEntity schedule = new ScheduleRecordEntity();
                            BeanUtils.copyProperties(rangeVo, schedule);
                            schedule.setStatus(WhetherEnum.ALLOW.getValue());
                            schedule.setScheduleDate(DateUtils.getNextWeek(schDate, 3));
//                            schedule.setAvailableCount(rangeVo.getTotalCount());
                            log.info("排班新增入参:" + schedule.toString());
                            scheduleRecordMapper.insert(schedule);
                        });
                        continue;
                    }
                }
            }
        }

    }
}
