package com.ebaiyihui.family.doctor.server.task;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.family.doctor.common.bo.Result;
import com.ebaiyihui.family.doctor.common.dto.HealthInfoDTO;
import com.ebaiyihui.family.doctor.common.dto.SendImMsgDTO;
import com.ebaiyihui.family.doctor.server.common.constants.CommonConstants;
import com.ebaiyihui.family.doctor.server.common.constants.ImConstants;
import com.ebaiyihui.family.doctor.server.common.enums.MsgTempTypeEnum;
import com.ebaiyihui.family.doctor.server.common.enums.StatusEnum;
import com.ebaiyihui.family.doctor.server.entity.MobileBenefitPackageEntity;
import com.ebaiyihui.family.doctor.server.entity.PatientSignEntity;
import com.ebaiyihui.family.doctor.server.mapper.MobileBenefitPackageMapper;
import com.ebaiyihui.family.doctor.server.service.ImMsgTemplateService;
import com.ebaiyihui.family.doctor.server.service.PatientSignService;
import com.ebaiyihui.family.doctor.server.util.DateUtils;
import com.ebaiyihui.family.doctor.server.util.ThirdOrderPushUtil;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.imforward.client.vo.IMQueryMsgReqVO;
import com.ebaiyihui.imforward.client.vo.IMQueryUserLoginReqVO;
import com.ebaiyihui.imforward.client.vo.IMQueryUserLoginRspVO;
import com.ebaiyihui.imforward.client.vo.IMSingleMsgResultVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @ClassName: SignedTask
 * @Author:yanliang
 * @Date:2024/3/22 10:20
 * @Description
 */
@Component
@Slf4j
public class SignedTask {

    @Autowired
    private ImMsgTemplateService imMsgTemplateService;

    @Autowired
    private PatientSignService patientSignSevice;

    @Autowired
    private MobileBenefitPackageMapper mobileBenefitPackageMapper;

    @Autowired
    private ThirdOrderPushUtil thirdOrderPushUtil;

    //    @Scheduled(cron = "0 0 10 * * ?")
    public void healthRecordWhetherUpdate() {
        List<PatientSignEntity> patientSignEntities = patientSignSevice.selectList(new PatientSignEntity());
        if (!patientSignEntities.isEmpty()) {
            for (PatientSignEntity ps : patientSignEntities) {
                HealthInfoDTO healthInfoDTO = new HealthInfoDTO();
                healthInfoDTO.setPhone(ps.getPatientPhone());
                // 查询用户健康档案30天内是否有更新
                String result = thirdOrderPushUtil.getHealthRecordWhetherUpdate(healthInfoDTO);
                Result<Boolean> res = JSONObject.parseObject(result, Result.class);
                Boolean flag = res.getData();
                SendImMsgDTO sendImMsgDTO = new SendImMsgDTO();
                sendImMsgDTO.setAppCode(CommonConstants.APP_CODE);
                sendImMsgDTO.setOrganId(CommonConstants.ORGAN_CODE);
                sendImMsgDTO.setAdmId(ps.getAdmId());
                if (!flag) {
                    sendImMsgDTO.setType(MsgTempTypeEnum.ACT_PUSH_HEAL_REC.getValue());
                    imMsgTemplateService.sendImMsg(sendImMsgDTO);
                }
                // 1、签约完成定时任务第10天，主动触发 2、定时任务之后每隔15天，主动触发
                Date curDate = new Date();
                int difDay = DateUtils.daysBetween(ps.getCreateTime(), curDate);
                int afterFifteenDay = DateUtils.daysBetween(ps.getCreateTime(), curDate);
                if (10 == difDay || afterFifteenDay % 15 == 0) {
                    sendImMsgDTO.setType(MsgTempTypeEnum.ACT__SIG_SUC.getValue());
                    imMsgTemplateService.sendImMsg(sendImMsgDTO);
                }
                // 1、当用户有触发过‘报告异常’问诊 2、定时任务触发20天后主动触发
                if (20 == difDay) {
                    sendImMsgDTO.setType(MsgTempTypeEnum.ACT_FU_REP_ANO.getValue());
                    imMsgTemplateService.sendImMsg(sendImMsgDTO);
                }
                // 1、当用户与医生7天未进行沟通 2、判断后主动触发
                // {"appCode":"EHOS_PATIENT","appointmentId":["9ad0b140bd1b4b86b1aa68f59c9dbf9a"],"businessCode":"jtys","msgType":"1","page":0,"pageSize":999,"sortOrder":"ASC","userId":"18170905967"}
                IMQueryMsgReqVO imQueryMsgReqVO = new IMQueryMsgReqVO();
                imQueryMsgReqVO.setAppCode(ImConstants.IM_PAT_ACCOUNT_NUM);
                imQueryMsgReqVO.setBusinessCode(ImConstants.IM_QUERY_ACCOUNT_CODE);
                imQueryMsgReqVO.setMsgType("1");
                imQueryMsgReqVO.setPageSize(10);
                imQueryMsgReqVO.setSortOrder("DESC");
                List<String> appointmentIds = new ArrayList<>();
                appointmentIds.add(ps.getAdmId());
                imQueryMsgReqVO.setAppointmentId(appointmentIds);
                imQueryMsgReqVO.setUserId(ps.getPatientUserId());
                String sendTimeStr = "2023-12-01 00:00:00";
                try {
                    BaseResponse<List<IMSingleMsgResultVO>> msgContent = patientSignSevice.getAllMsgContent(imQueryMsgReqVO);
                    if ("1".equals(msgContent.getCode())) {
                        List<IMSingleMsgResultVO> imSingleMsgResultVOS = msgContent.getData();
                        IMQueryUserLoginReqVO imQueryUserLoginReqVO = new IMQueryUserLoginReqVO();
                        imQueryUserLoginReqVO.setAppCode(ImConstants.IM_PAT_ACCOUNT_NUM);
                        imQueryUserLoginReqVO.setUserId(ps.getPatientUserId());
                        BaseResponse<IMQueryUserLoginRspVO> sdkLogin = patientSignSevice.querySdkLogin(imQueryUserLoginReqVO);
                        if ("1".equals(sdkLogin.getCode())) {
                            IMQueryUserLoginRspVO imQueryUserLoginRspVO = sdkLogin.getData();
                            String sdkAccount = imQueryUserLoginRspVO.getSdkAccount();
                            for (IMSingleMsgResultVO imSingleMsgResultVO : imSingleMsgResultVOS) {
                                if (imSingleMsgResultVO.getSender().equals(sdkAccount)) {
                                    sendTimeStr = imSingleMsgResultVO.getSendTime();
                                    break;
                                }
                            }
                        }
                        Date sendTime = DateUtils.parseDate(sendTimeStr, DateUtils.FULL_FORMAT);
                        int difSendDay = DateUtils.daysBetween(sendTime, curDate);
                        if (7 == difSendDay) {
                            sendImMsgDTO.setType(MsgTempTypeEnum.ACT_FU_UN_CON.getValue());
                            imMsgTemplateService.sendImMsg(sendImMsgDTO);
                        }
                    }
                } catch (Exception e) {
                    log.error("获取发送消息异常", e);
                }
            }
        }

    }

    //    @Scheduled(cron = "0 0 20 * * ?")
    public void holidayPush() {
        List<PatientSignEntity> patientSignEntities = patientSignSevice.selectList(new PatientSignEntity());
        try {
            if (!patientSignEntities.isEmpty()) {
                for (PatientSignEntity ps : patientSignEntities) {

                    SendImMsgDTO sendImMsgDTO = new SendImMsgDTO();
                    sendImMsgDTO.setAppCode(CommonConstants.APP_CODE);
                    sendImMsgDTO.setOrganId(CommonConstants.ORGAN_CODE);
                    sendImMsgDTO.setAdmId(ps.getAdmId());
                    Date curDate = new Date();
                    Date qmBeforeDay = DateUtils.getQingMingBeforeDay(curDate);
                    Date curDay = DateUtils.parseDate(DateUtils.getFormatDateString(curDate, DateUtils.SIMPLE_FORMAT), DateUtils.SIMPLE_FORMAT);
                    if (qmBeforeDay.equals(curDay)) {
                        sendImMsgDTO.setType(MsgTempTypeEnum.ACT_FU_TSD.getValue());
                        imMsgTemplateService.sendImMsg(sendImMsgDTO);
                    }

                    Date laborBeforeDay = DateUtils.getLaborBeforeDay(curDate);
                    if (laborBeforeDay.equals(curDay)) {
                        sendImMsgDTO.setType(MsgTempTypeEnum.ACT_FU_LD.getValue());
                        imMsgTemplateService.sendImMsg(sendImMsgDTO);
                    }

                    Date duanWuBeforeDay = DateUtils.getLaborBeforeDay(curDate);
                    if (duanWuBeforeDay.equals(curDay)) {
                        sendImMsgDTO.setType(MsgTempTypeEnum.ACT_FU_TDBF.getValue());
                        imMsgTemplateService.sendImMsg(sendImMsgDTO);
                    }

                    Date zhongQiuBeforeDay = DateUtils.getZhongQiuBeforeDay(curDate);
                    if (zhongQiuBeforeDay.equals(curDay)) {
                        sendImMsgDTO.setType(MsgTempTypeEnum.ACT_FU_MAF.getValue());
                        imMsgTemplateService.sendImMsg(sendImMsgDTO);
                    }

                    Date guoQingBeforeDay = DateUtils.getGuoQingBeforeDay(curDate);
                    if (guoQingBeforeDay.equals(curDay)) {
                        sendImMsgDTO.setType(MsgTempTypeEnum.ACT_FU_MAF.getValue());
                        imMsgTemplateService.sendImMsg(sendImMsgDTO);
                    }
                }
            }
        } catch (Exception e) {
            log.error("节日日期转换异常", e);
        }
    }

    //    @Scheduled(cron = "0 0 1 * * ?")
    public void orderInvalidation() {
        List<MobileBenefitPackageEntity> mobileBenefitPackageEntities = mobileBenefitPackageMapper.queryMaxOneList();
        try {
            if (!mobileBenefitPackageEntities.isEmpty()) {
                for (MobileBenefitPackageEntity mbp : mobileBenefitPackageEntities) {
                    Date curTime = new Date();
                    Date endTime = DateUtils.parseDate(mbp.getBenefitsEndTime(), DateUtils.FULL_FORMAT);
                    PatientSignEntity patientSignEntity = patientSignSevice.getOneByPhone(mbp.getPhone());
                    mbp.setVersion(1);
                    if (endTime.after(curTime)) {
                        patientSignEntity.setPackageOrderId(mbp.getActivateOrderId());
                        patientSignEntity.setSignEndTime(endTime);
                    } else {
                        patientSignEntity.setStatus(StatusEnum.FINISH_APPLY.getValue());
                    }
                    patientSignSevice.updateById(patientSignEntity);
                    mobileBenefitPackageMapper.updateVersion(mbp);
                }
            }
        } catch (Exception e) {
            log.error("日期转换异常", e);
        }
    }
}
