package com.ebaiyihui.family.doctor.server.util;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.binary.Base64;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import java.nio.charset.StandardCharsets;

/**
 * @ClassName: DESUtils
 * @Author:yanliang
 * @Date:2024/3/19 11:10
 * @Description
 */
@Slf4j
public class DESUtils {

    /**
     * DES 加密
     *
     * <dependency>* <groupId>commons-codec</groupId>
     * <artifactId>commons-codec</artifactId>
     * <version>1.14</version>
     * </dependency>
     * <p>
     * org.apache.commons.codec.binary.Base64
     *
     * @param originData 原始数据,未加密
     * @param secret     加密秘钥
     * @return
     */
    public static String encrypt(String originData, String secret) {
        try {
            DESedeKeySpec dks = new
                    DESedeKeySpec(secret.getBytes(StandardCharsets.UTF_8));
            SecretKeyFactory keyFactory =
                    SecretKeyFactory.getInstance("DESede");
            SecretKey securekey = keyFactory.generateSecret(dks);
            Cipher cipher = Cipher.getInstance("DESede/ECB/PKCS5Padding");
            cipher.init(Cipher.ENCRYPT_MODE, securekey);
            byte[] b = cipher.doFinal(originData.getBytes());
            return new String(Base64.encodeBase64(b),
                    StandardCharsets.UTF_8).replaceAll("\r", "").replaceAll("\n", "");
        } catch (Exception e) {
            log.error("加密异常:{}", e);
            return "";
        }
    }

    /**
     * DES 解密
     *
     * @param encryptData 加密串
     * @param secret      加密/解密 secret
     * @return
     */
    public static String decrypt(String encryptData, String secret) {
        try {
            // --通过 base64,将字符串转成 byte 数组
            byte[] bytesrc = Base64.decodeBase64(encryptData.getBytes());
            // --解密的 key
            DESedeKeySpec dks = new DESedeKeySpec(secret.getBytes(StandardCharsets.UTF_8));
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DESede");
            SecretKey securekey = keyFactory.generateSecret(dks);
            // --Chipher 对象解密
            Cipher cipher = Cipher.getInstance("DESede/ECB/PKCS5Padding");
            cipher.init(Cipher.DECRYPT_MODE, securekey);
            byte[] retByte = cipher.doFinal(bytesrc);
            return new String(retByte);
        } catch (Exception e) {
            log.error("解密异常:", e);
            return "";
        }
    }
}
