package com.ebaiyihui.family.doctor.server.util;

import com.ebaiyihui.family.doctor.server.common.enums.ScheduleRecordEnum;
import com.ebaiyihui.family.doctor.server.common.enums.WhetherEnum;
import org.apache.commons.lang.StringUtils;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.*;

/**
 * @ClassName: DateUtils
 * @Author:yanliang
 * @Date:2024/3/11 17:15
 * @Description 日期处理类
 */

public class DateUtils {

    public final static String FULL_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public final static String SIMPLE_FORMAT = "yyyy-MM-dd";

    public final static String FORMAT = "yyyyMMddHHmmss";

    public final static String SIMPLE_NOSPE_FORMAT = "yyyyMMdd";

    public final static String SIMPLE_TIME_FORMAT = "HH:mm:ss";
    public final static String SIMPLE_TIME_FORMAT_MINUTE = "mm:ss";

    public final static String YEAR = "yyyy";


    /**
     * 分钟 转 天时分
     **/
    public static String toDayHourMinuteString(int minute) {

        if (0 == minute) {
            return 24 + "小时";
        }
        if (0 < minute && minute < 60) {
            return minute + "分钟";
        }
        if (60 <= minute && minute < 1440) {

            if (minute % 60 == 0) {
                int h = minute / 60;
                return h + "小时";
            } else {
                int h = minute / 60;
                int m = minute % 60;
                return h + "小时" + m + "分钟";
            }

        }
        if (minute >= 1440) {

            int d = minute / 60 / 24;
            int h = minute / 60 % 24;
            int m = minute % 60;
            String s1 = null;
            if (d > 0) {
                s1 = d + "天";
            }
            if (h >= 1) {
                s1 += h + "小时";
            }
            if (m > 0) {
                s1 += m + "分钟";
            }

            return s1;
        }
        return null;
    }

    /**
     * 2020-3-1 2020-03-01
     */
    public static String getDate(String date) {

        String[] s1 = date.split(" ");
        String dateStr = s1[0];
        String dateFormart = SIMPLE_FORMAT;
        SimpleDateFormat format = new SimpleDateFormat(SIMPLE_FORMAT);

        String newDateStr = null;
        try {
            newDateStr = format.format(format.parse(dateStr));
        } catch (ParseException e) {
            e.printStackTrace();
        }

        return newDateStr;
    }

    /**
     * @param second
     * @param
     * @return java.lang.String
     **/
    public static String secondToDateTime(long second) {
        Calendar calendar = Calendar.getInstance();
        //转换为毫秒
        calendar.setTimeInMillis(second * 1000);
        Date date = calendar.getTime();
        SimpleDateFormat format = new SimpleDateFormat(FULL_FORMAT);
        String dateString = format.format(date);
        return dateString;

    }


    /**
     * 秒 转 时分秒
     * 280秒 转 10:00:00
     **/
    public static String tosecondString(String str) {

        Integer second = Integer.valueOf(str);

        String h1 = null;
        String m1 = null;
        String s1 = null;

        if (second < 60) {
            return "00" + ":" + "00" + ":" + str;
        }

        if (60 <= second && second < 3600) {
            Integer m = second / 60;
            if (0 <= m && m < 10) {
                m1 = "0" + m;
            } else {
                m1 = m.toString();
            }
            Integer s = second % 60;
            if (0 <= s && s < 10) {
                s1 = "0" + s;
            } else {
                s1 = s.toString();
            }
            return "00" + ":" + m1 + ":" + s1;
        }

        if (second >= 3600) {
            Integer h = second / 3600;
            if (0 <= h && h < 10) {
                h1 = "0" + h;
            } else {
                h1 = h.toString();
            }
            Integer m = (second % 3600) / 60;
            if (0 <= m && m < 10) {
                m1 = "0" + m;
            } else {
                m1 = m.toString();
            }
            Integer s = (second % 3600) % 60;
            if (0 <= s && s < 10) {
                s1 = "0" + s;
            } else {
                s1 = s.toString();
            }
            return h1 + ":" + m1 + ":" + s1;
        }
        return null;
    }

    /**
     * 获得当前 时:分:秒
     *
     * @return
     */
    public static String getCurrentTime() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat(SIMPLE_TIME_FORMAT);
        return df.format(calendar.getTime());
    }

    /**
     * 得到几天前的时间
     *
     * @param d
     * @param day
     * @return
     */
    public static Date getDateBefore(Date d, int day) {
        Calendar now = Calendar.getInstance();
        now.setTime(d);
        now.set(Calendar.DATE, now.get(Calendar.DATE) - day);
        return now.getTime();
    }


    /**
     * 得到几天后的时间
     *
     * @param d
     * @param day
     * @return
     */
    public static Date getDateAfter(Date d, int day) {
        Calendar now = Calendar.getInstance();
        now.setTime(d);
        now.set(Calendar.DATE, now.get(Calendar.DATE) + day);
        return now.getTime();
    }

    /**
     * 得到 (Date类型的日期+N个月) 的日期Date类型  加法
     *
     * @param date
     * @param month
     * @return
     */
    public static Date getAddMonth(Date date, int month) {
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        now.add(Calendar.MONTH, month);
        return now.getTime();
    }

    /**
     * 得到 (Date类型的日期-N个月) 的日期字符串   减法
     *
     * @param date
     * @param month
     * @return
     */
    public static Date getSubtractMonth(Date date, int month) {
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        now.add(Calendar.MONTH, -month);
        return now.getTime();
    }

    /**
     * 得到 (Date类型的日期+N年) 的日期Date类型  加法
     *
     * @param date
     * @param month
     * @return
     */
    public static Date getAddYear(Date date, int year) {
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        now.add(Calendar.YEAR, year);
        return now.getTime();
    }

    /**
     * 得到 (Date类型的日期-N个月) 的日期字符串   减法
     *
     * @param date
     * @param month
     * @return
     */
    public static Date getSubtractYear(Date date, int year) {
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        now.add(Calendar.YEAR, -year);
        return now.getTime();
    }

    private static Calendar initCurrentDate() {
        Date date = new Date(System.currentTimeMillis());
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c;
    }

    public static int getCurrentYear() {
        Calendar c = initCurrentDate();
        return c.get(Calendar.YEAR);
    }

    public static int getCurrentMonth() {
        return initCurrentDate().get(Calendar.MONTH) + 1;
    }

    public static int getCurrentDay() {
        return initCurrentDate().get(Calendar.DAY_OF_MONTH);
    }

    public static int getCurrentHour() {
        return initCurrentDate().get(Calendar.HOUR_OF_DAY);
    }

    public static int getCurrentMinute() {
        return initCurrentDate().get(Calendar.MINUTE);
    }

    public static int getCurrentSecond() {
        return initCurrentDate().get(Calendar.SECOND);
    }

    public static String getCurrentDate(String format) {
        SimpleDateFormat parse = new SimpleDateFormat(format);
        return parse.format(new Date());
    }

    public static Date parseDate(String str, String parsePatterns) throws ParseException {
        if (str == null || parsePatterns == null) {
            throw new IllegalArgumentException("Date and Patterns must not be null");
        }

        SimpleDateFormat parser = null;
        ParsePosition pos = new ParsePosition(0);
        parser = new SimpleDateFormat(parsePatterns);
        pos.setIndex(0);
        Date date = parser.parse(str, pos);
        if (date != null && pos.getIndex() == str.length()) {
            return date;
        }
        throw new ParseException("Unable to parse the date: " + str, -1);
    }

    public static String dateToString(Date date, String par) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(par);
        return sdf.format(date);
    }

    /**
     * 将日期字符串转换为长整型
     *
     * @param date 格式(yyyy-MM-dd)
     * @return
     */
    public static long strToDateLong(String date) {
        long l = 0L;
        try {
            Calendar ca = Calendar.getInstance();
            ca.setTime(java.sql.Date.valueOf(date));
            l = ca.getTimeInMillis();
        } catch (Exception e) {
            new Exception("日期字符串转长整形错误", e);
        }
        return l;
    }

    public static String longToStrDate(String format, long time) {
        DateFormat df = new SimpleDateFormat(format);
        return df.format(new Date(time));
    }

    public static Date strToDate(String str, String parsePatterns) throws ParseException {
        return parseDate(str, parsePatterns);
    }

    /**
     * 得到 n 天后的日期
     *
     * @param days
     * @return
     */
    public static Date getAfterCurrentDay(int days) {
        Date result = null;
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.add(Calendar.DAY_OF_WEEK, +days);
            result = calendar.getTime();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    /**
     * 得到当前日期的指定格式
     *
     * @return
     */
    public static String getFormatDateString(Date date, String format) {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(date);
    }


    /**
     * 得到当前日期的年月日时分秒
     *
     * @return
     */
    public static String getCurrentDateTimeString() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat(FORMAT);
        return df.format(calendar.getTime());
    }

    /**
     * 得到当前日期的年-月-日 时:分:秒
     *
     * @return
     */
    public static String getCurrentDateToString() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat(FULL_FORMAT);
        return df.format(calendar.getTime());
    }

    /**
     * 得到当前日期的年-月-日
     *
     * @return
     */
    public static String getCurrentDateSimpleToString() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat(SIMPLE_FORMAT);
        return df.format(calendar.getTime());
    }

    /**
     * 得到当前日期的yyyymmdd
     *
     * @return
     */
    public static String getCurrentDateSimpleNoSpeToString() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat(SIMPLE_NOSPE_FORMAT);
        return df.format(calendar.getTime());
    }

    /**
     * 得到当前日期的年-月-日
     *
     * @return
     */
    public static Date getCurrentDate() {
        Calendar calendar = Calendar.getInstance();
        return calendar.getTime();
    }

    /**
     * 得到当前日期的年-月-日
     *
     * @return
     */
    public static Timestamp getCurrentDateTimestamp() {
        Calendar calendar = Calendar.getInstance();
        return new Timestamp(calendar.getTime().getTime());
    }

    /**
     * 得到当天到下周的日期
     *
     * @return
     */
    public static String getNextWeekToString() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.DAY_OF_WEEK, +6);
        SimpleDateFormat df = new SimpleDateFormat(SIMPLE_FORMAT);
        return df.format(calendar.getTime());
    }

    /**
     * 得到明天的时间
     *
     * @return
     */
    public static String getNextDayToString(String day) {
        String result = "";
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat(SIMPLE_FORMAT);
        try {
            calendar.setTime(df.parse(day));
            calendar.add(Calendar.DAY_OF_WEEK, +1);
            result = df.format(calendar.getTime());
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getLastWeekToString() {
        String result = "";
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat(SIMPLE_FORMAT);
        try {
            // 周数减一，即上周
            calendar.add(Calendar.WEEK_OF_MONTH, -1);
            result = df.format(calendar.getTime());
        } catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    /**
     * 获取昨天日期
     *
     * @param day
     * @return
     */
    public static String getYestarDayToString(String day) {
        String result = "";
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat(SIMPLE_FORMAT);
        try {
            calendar.setTime(df.parse(day));
            calendar.add(Calendar.DAY_OF_WEEK, -1);
            result = df.format(calendar.getTime());
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return result;
    }

    /**
     * 字符串日期转Date类型
     *
     * @param str
     * @return
     */
    public static Date stringToSimpleDate(String str) {
        if (str == null || "".equals(str)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(SIMPLE_FORMAT);
        try {
            return df.parse(str);
        } catch (ParseException e) {
            return null;
        }
    }

    /**
     * 字符串日期转Date类型
     *
     * @param str
     * @return
     */
    public static Date stringToFullDate(String str) {
        if (str == null || "".equals(str)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(FULL_FORMAT);
        try {
            return df.parse(str);
        } catch (ParseException e) {
            return null;
        }
    }

    /**
     * Date类型转字符串日期
     *
     * @param str
     * @return
     */
    public static String dateToSimpleString(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat(SIMPLE_FORMAT);
        return df.format(date);
    }

    /**
     * Date类型转字符串日期
     *
     * @param str
     * @return
     */
    public static String dateToFullString(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat(FULL_FORMAT);
        return df.format(date);
    }

    /**
     * 根据日期得到星期几
     *
     * @param date
     * @return
     */
    public static String getWeekChinese(String date) {
        String[] weekDays = {"星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六"};
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat(SIMPLE_FORMAT);
        try {
            cal.setTime(df.parse(date));
        } catch (ParseException e) {
            e.printStackTrace();
        }
        int w = cal.get(Calendar.DAY_OF_WEEK) - 1;
        if (w < 0) {
            w = 0;
        }
        return weekDays[w];
    }


    public static String getForWeek(String date) {
        String[] weekDays = {"周日", "周一", "周二", "周三", "周四", "周五", "周六"};
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat(SIMPLE_FORMAT);
        try {
            cal.setTime(df.parse(date));
        } catch (ParseException e) {
            e.printStackTrace();
        }
        int w = cal.get(Calendar.DAY_OF_WEEK) - 1;
        if (w < 0) {
            w = 0;
        }
        return weekDays[w];
    }


    /**
     * 判断两个时间的大小 是否后面那个大于前面那个 格式 yyyy-MM-dd
     *
     * @param startDate
     * @param endDate
     * @return true为是 false为否
     */
    public static boolean judgeDate(String startStr, String endStr) {
        Date startDate = stringToSimpleDate(startStr);
        Date endDate = stringToSimpleDate(endStr);
        if (startDate.before(endDate)) {
            return true;
        }
        return false;
    }

    /**
     * 判断两个时间的大小 是否后面那个大于或等于前面那个 格式 yyyy-MM-dd
     *
     * @param startDate
     * @param endDate
     * @return true为是 false为否
     */
    public static boolean judgeDateEqual(String startStr, String endStr) {
        Date startDate = stringToSimpleDate(startStr);
        Date endDate = stringToSimpleDate(endStr);
        if (startDate.before(endDate) || startDate.compareTo(endDate) == 0) {
            return true;
        }
        return false;
    }

    /**
     * 判断两个时间的大小 是否后面那个大于或等于前面那个 格式 yyyy-MM-dd hh:mm:ss
     *
     * @param startDate
     * @param endDate
     * @return true为是 false为否
     */
    public static boolean judgeFullDateEqual(String startStr, String endStr) {
        Date startDate = stringToSimpleDate(startStr);
        Date endDate = stringToSimpleDate(endStr);
        if (startDate.before(endDate) || startDate.compareTo(endDate) == 0) {
            return true;
        }
        return false;
    }


    /**
     * 得到多少天的日期 正数为加 负数为减
     *
     * @param str
     * @param day
     * @return
     */
    public static String getNumAfterDate(String str, int day) {
        Date startDate = stringToSimpleDate(str);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        calendar.add(Calendar.DAY_OF_WEEK, day);
        return dateToSimpleString(calendar.getTime());
    }

    /**
     * 将UNIXTIME转为普通的时间
     *
     * @param unixTime
     * @return
     */
    public static String unixTimeToString(String unixTime) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(Long.parseLong(unixTime));
        return dateToSimpleString(c.getTime());
    }

    /**
     * 将普通的日间转为UNIXTIME
     *
     * @param date
     * @return
     */
    public static String stringToUnixTime(String date) {
        Calendar c = Calendar.getInstance();
        Date date2 = stringToSimpleDate(date);
        c.setTime(date2);
        return c.getTimeInMillis() + "";

    }

    /**
     * 将时间字符串转化成Timestamp时间戳（String的类型必须形如： yyyy-mm-dd hh:mm:ss 这样的格式，否则报错）
     *
     * @param tsStr
     * @return Timestamp
     */
    public static Timestamp stringToTimestamp(String tsStr) {
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        try {
            ts = Timestamp.valueOf(tsStr);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return ts;
    }

    /**
     * 时间戳转字符串
     *
     * @param ccTime
     * @return
     */
    public static String getStrByTimestamp(Timestamp ccTime) {
        SimpleDateFormat sdf = new SimpleDateFormat(FULL_FORMAT);
        return sdf.format(ccTime);
    }

    @SuppressWarnings("static-access")
    public static Time strToTime(String strDate) {
        if ("".equals(strDate) || strDate == null) {
            return null;
        }
        String str = strDate;
        SimpleDateFormat format = new SimpleDateFormat("hh:mm:ss");
        Date d = null;
        try {
            d = format.parse(str);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return Time.valueOf(str);
    }

    public static Time getTime() {
        Date d = new Date();
        // SimpleDateFormat format = new SimpleDateFormat("hh:mm:ss");
        Time time = new Time(d.getTime());
        return time;
    }

    /**
     * dateB - dateA  的日期天数
     *
     * @param dateA
     * @param dateB
     * @return
     */
    public static int getBetweenDayNumber(Date dateA, Date dateB) {
        long dayNumber = 0;
        long day = 24L * 60L * 60L * 1000L;
        try {
            dayNumber = (dateB.getTime() - dateA.getTime()) / day;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return (int) dayNumber;
    }

    /**
     * 计算两个日期相差的天数 date2-date1
     *
     * @param date1
     * @param date2
     * @return
     */
    public static int daysBetween(Date date1, Date date2) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        long time1 = cal.getTimeInMillis();
        cal.setTime(date2);
        long time2 = cal.getTimeInMillis();
        long betweenDays = (time2 - time1) / (1000 * 3600 * 24);
        return Integer.parseInt(String.valueOf(betweenDays));
    }

    /**
     * 计算两个日期相差的秒数 date2-date1
     *
     * @param date1
     * @param date2
     * @return
     */
    public static int secondsBetween(Date date1, Date date2) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        long time1 = cal.getTimeInMillis();
        cal.setTime(date2);
        long time2 = cal.getTimeInMillis();
        long betweenDays = (time2 - time1) / 1000;
        return Integer.parseInt(String.valueOf(betweenDays));
    }

    /**
     * 计算两个日期相差的秒数 date2-date1-1个小时
     *
     * @param date1
     * @param date2
     * @return
     */
    public static Long secondsBetweenOneHour(Date date1, Date date2) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        long time1 = cal.getTimeInMillis();
        cal.setTime(date2);
        long time2 = cal.getTimeInMillis();
        long betweenSeconds = 0L;
        betweenSeconds = time2 - time1;
        if (betweenSeconds < (1000 * 3600)) {

            betweenSeconds = 0;

        } else {
            betweenSeconds = betweenSeconds - (1000 * 3600);
        }
        return betweenSeconds;
    }

    /**
     * 计算两个日期相差的小时 date2-date1
     *
     * @param date1
     * @param date2
     * @return
     */
    public static int hoursBetween(Date date1, Date date2) {
        if (date1.after(date2)) {
            return 0;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        long time1 = cal.getTimeInMillis();
        cal.setTime(date2);
        long time2 = cal.getTimeInMillis();
        long betweenDays = (time2 - time1) / 1000 / 3600;
        return Integer.parseInt(String.valueOf(betweenDays));
    }

    /**
     * 计算两个日期相差的分钟 date2-date1
     *
     * @param date1
     * @param date2
     * @return
     */
    public static int minuteBetween(Date date1, Date date2) {
        if (date1.after(date2)) {
            return 0;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        long time1 = cal.getTimeInMillis();
        cal.setTime(date2);
        long time2 = cal.getTimeInMillis();
        long betweenDays = (time2 - time1) / 1000 / 60;
        return Integer.parseInt(String.valueOf(betweenDays));
    }

    /**
     * 日期增加天数
     *
     * @param date
     * @param addDays
     * @return
     */
    public static Date dateAddDays(Date date, int addDays) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.DATE, addDays);
        return calendar.getTime();
    }

    /**
     * 日期增加小时
     *
     * @param date
     * @param addHours
     * @return
     */
    public static Date dateAddHours(Date date, int addHours) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.HOUR_OF_DAY, addHours);
        return calendar.getTime();
    }

    /**
     * 时间增加小时
     *
     * @param day
     * @param hour
     * @return
     */
    public static Date addDateMinut(Date day, int hour) {

        Calendar cal = Calendar.getInstance();
        cal.setTime(day);
        // 24小时制
        cal.add(Calendar.HOUR, hour);
        Date time = cal.getTime();
        return time;
    }


    /**
     * 日期增加分钟
     *
     * @param date
     * @param addMinutes
     * @return
     */
    public static Date dateAddMinutes(Date date, int addMinutes) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(Calendar.MINUTE, addMinutes);
        return calendar.getTime();
    }

    /**
     * long类型转换为String类型
     *
     * @param currentTime 要转换的long类型的时间
     * @param formatType  要转换的string类型的时间格式
     * @return
     * @throws ParseException
     */
    public static String longToString(long currentTime, String formatType) throws ParseException {
        // long类型转成Date类型
        Date date = longToDate(currentTime, formatType);
        // date类型转成String
        String strTime = dateToString(date, formatType);
        return strTime;
    }

    /**
     * string 类型转为时间戳，格式为(yyyy-MM-dd HH:mm:ss)
     *
     * @param strDateTime
     * @return
     */
    public static long StringTolong(String strDateTime) {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        long timeStamp = 0L;
        try {
            LocalDateTime localDateTime = LocalDateTime.parse(strDateTime, dtf);
            timeStamp = localDateTime.toInstant(ZoneOffset.of("+8")).toEpochMilli();
        } catch (Exception e) {
            return timeStamp;
        }
        return timeStamp;
    }

    /**
     * string类型转换为date类型
     *
     * @param strTime要转换的string类型的时间，formatType要转换的格式yyyy-MM-dd HH:mm:ss//yyyy年MM月dd日
     * @param formatType
     * @return
     * @throws ParseException
     */
    public static Date stringToDate(String strTime, String formatType) {
        SimpleDateFormat formatter = new SimpleDateFormat(formatType);
        Date date = null;
        try {
            date = formatter.parse(strTime);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    /**
     * long转换为Date类型
     *
     * @param currentTime                  要转换的long类型的时间
     * @param formatType要转换的时间格式yyyy-MM-dd HH:mm:ss//yyyy年MM月dd日 HH时mm分ss秒
     * @return
     * @throws ParseException
     */
    public static Date longToDate(long currentTime, String formatType) throws ParseException {
        // 根据long类型的毫秒数生命一个date类型的时间
        Date dateOld = new Date(currentTime);
        // 把date类型的时间转换为string
        String sDateTime = dateToString(dateOld, formatType);
        // 把String类型转换为Date类型
        Date date = stringToDate(sDateTime, formatType);
        return date;
    }

    /**
     * date类型转换为long类型
     *
     * @param date要转换的date类型的时间
     * @return
     */
    public static long dateToLong(Date date) {
        return date.getTime();
    }

    /**
     * 时 分 秒 置0
     *
     * @param d
     * @param hour
     * @param min
     * @param second
     * @return
     */
    public static Date setPrecise(Date d, int hour, int min, int second) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(d);
        calendar.set(GregorianCalendar.HOUR_OF_DAY, hour);
        calendar.set(GregorianCalendar.MINUTE, min);
        calendar.set(GregorianCalendar.SECOND, second);
        calendar.set(GregorianCalendar.MILLISECOND, 0);
        return calendar.getTime();
    }

    /**
     * 获取当前时间第二天的起始时间
     *
     * @return
     * @author ZhangWei
     */
    public static Date getNextDayStartTime() {
        Date date = new Date();
        Calendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.add(Calendar.DAY_OF_YEAR, 1);
        calendar.set(Calendar.HOUR_OF_DAY, 0);
        calendar.set(Calendar.MINUTE, 0);
        calendar.set(Calendar.SECOND, 0);
        calendar.set(Calendar.MILLISECOND, 0);
        return calendar.getTime();
    }


    /**
     * 获取本周的开始时间
     *
     * @return
     */
    public static Date getBeginDayOfWeek() {
        Date date = new Date();
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayofweek = cal.get(Calendar.DAY_OF_WEEK);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(Calendar.DATE, 2 - dayofweek);
        return getDayStartTime(cal.getTime());
    }

    /**
     * 获取本周的结束时间
     *
     * @return
     */
    public static Date getEndDayOfWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(getBeginDayOfWeek());
        cal.add(Calendar.DAY_OF_WEEK, 6);
        Date weekEndSta = cal.getTime();
        return getDayEndTime(weekEndSta);
    }

    /**
     * 获取上周的开始时间
     *
     * @return
     */
    public static Date getBeginDayOfLastWeek(Integer min) {
        Date date = new Date();
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayofweek = cal.get(Calendar.DAY_OF_WEEK);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(Calendar.DATE, 2 - dayofweek - min * 7);
        return getDayStartTime(cal.getTime());
    }

    /**
     * 获取上周的结束时间
     *
     * @return
     */
    public static Date getEndDayOfLastWeek(Integer min) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(getBeginDayOfLastWeek(min));
        cal.add(Calendar.DAY_OF_WEEK, 6);
        Date weekEndSta = cal.getTime();
        return getDayEndTime(weekEndSta);
    }

    /**
     * 获取上上周的开始时间
     *
     * @return
     */
    public static Date getBeginDayLastWeek() {
        Date date = new Date();
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayofweek = cal.get(Calendar.DAY_OF_WEEK);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(Calendar.DATE, 2 - dayofweek - 4 * 7);
        return getDayStartTime(cal.getTime());
    }

    /**
     * 获取上上周的结束时间
     *
     * @return
     */
    public static Date getEndDayLastWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(getBeginDayLastWeek());
        cal.add(Calendar.DAY_OF_WEEK, 6);
        Date weekEndSta = cal.getTime();
        return getDayEndTime(weekEndSta);
    }

    /**
     * 获取下周的开始时间
     *
     * @return
     */
    public static Date getBeginDayOfNextWeek() {
        Date date = new Date();
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayofweek = cal.get(Calendar.DAY_OF_WEEK);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(Calendar.DATE, 2 - dayofweek + 7);
        return getDayStartTime(cal.getTime());
    }

    /**
     * 获取下周的结束时间
     *
     * @return
     */
    public static Date getEndDayOfNextWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(getBeginDayOfNextWeek());
        cal.add(Calendar.DAY_OF_WEEK, 6);
        Date weekEndSta = cal.getTime();
        return getDayEndTime(weekEndSta);
    }


    /**
     * 获取某个日期的开始时间
     *
     * @param d
     * @return
     */
    public static Timestamp getDayStartTime(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (null != d) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(Calendar.YEAR), calendar.get(Calendar.MONTH), calendar.get(Calendar.DAY_OF_MONTH), 0, 0, 0);
        calendar.set(Calendar.MILLISECOND, 0);
        return new Timestamp(calendar.getTimeInMillis());
    }


    /**
     * 获取某个日期的结束时间
     *
     * @param d
     * @return
     */
    public static Timestamp getDayEndTime(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (null != d) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(Calendar.YEAR), calendar.get(Calendar.MONTH), calendar.get(Calendar.DAY_OF_MONTH), 23, 59, 59);
        calendar.set(Calendar.MILLISECOND, 999);
        return new Timestamp(calendar.getTimeInMillis());
    }


    /**
     * 获取当天后7天结束时间
     *
     * @return
     */
    public static Date getWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date());
        cal.add(Calendar.DAY_OF_WEEK, 6);
        Date weekEndSta = cal.getTime();
        return getDayEndTime(weekEndSta);
    }

    /**
     * 获取当天的开始时间
     *
     * @return
     */
    public static Date date() {
        SimpleDateFormat deTime = new SimpleDateFormat("yyyy-MM-dd");
        Date date = new Date();
        String format = deTime.format(date);
        Date parse = null;
        try {
            parse = deTime.parse(format);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return parse;

    }


    /**
     * 获取下周的开始时间
     *
     * @return
     */
    public static Date getBegNextWeek(Integer min) {
        Date date = new Date();
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayofweek = cal.get(Calendar.DAY_OF_WEEK);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(Calendar.DATE, 2 - dayofweek + min * 7);
        return getDayStartTime(cal.getTime());
    }

    /**
     * 获取下周的结束时间
     *
     * @return
     */
    public static Date getEndNextWeek(Integer min) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(getBegNextWeek(min));
        cal.add(Calendar.DAY_OF_WEEK, 6);
        Date weekEndSta = cal.getTime();
        return getDayEndTime(weekEndSta);
    }


    public static Date updateDate(Date scheduleDate, Integer scheduleRange) {
        SimpleDateFormat df = new SimpleDateFormat(SIMPLE_FORMAT);
        String scheduledate = df.format(scheduleDate);
        String moStartTime = null;
        if (scheduleRange.equals(ScheduleRecordEnum.MORNING.getValue())) {
            moStartTime = scheduledate + " 09:00:00";
        }
        if (scheduleRange.equals(ScheduleRecordEnum.AFTERNOON.getValue())) {
            moStartTime = scheduledate + " 13:00:00";
        }
        if (scheduleRange.equals(ScheduleRecordEnum.EVENING.getValue())) {
            moStartTime = scheduledate + " 18:00:00";
        }
        Date parse = null;
        try {
            SimpleDateFormat dfs = new SimpleDateFormat(FULL_FORMAT);
            parse = dfs.parse(moStartTime);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(scheduleDate);
        calendar.add(Calendar.DATE, -2);
        return calendar.getTime();
    }

    public static Integer getExpirationTime(Date scheduleDate, Integer scheduleRange) {
        SimpleDateFormat df = new SimpleDateFormat(SIMPLE_FORMAT);
        String scheduledate = df.format(scheduleDate);
        String moStartTime = null;
        if (scheduleRange.equals(ScheduleRecordEnum.MORNING.getValue())) {
            moStartTime = scheduledate + " 12:00:00";
        }
        if (scheduleRange.equals(ScheduleRecordEnum.AFTERNOON.getValue())) {
            moStartTime = scheduledate + " 18:00:00";
        }
        if (scheduleRange.equals(ScheduleRecordEnum.EVENING.getValue())) {
            moStartTime = scheduledate + " 21:00:00";
        }
        Date parse = null;
        try {
            SimpleDateFormat dfs = new SimpleDateFormat(FULL_FORMAT);
            parse = dfs.parse(moStartTime);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        Date date = new Date();
        int after = parse.compareTo(date);
        if (after != 1) {
            return 1;
        }
        return 0;
    }


    public static Date dateToDateAsFormat(Date date) {

        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String sDate = simpleDateFormat.format(date);
        Date newDate = null;
        try {
            newDate = simpleDateFormat.parse(sDate);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return newDate;

    }

    public static Date stringToFullDateUtil(String str) {
        if (str == null || "".equals(str)) {
            return null;
        }

        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        try {
            return df.parse(str);
        } catch (ParseException e) {
            return null;
        }
    }

    public static Date stringToFullDateUtil1(String str) {
        if (str == null || "".equals(str)) {
            return null;
        }

        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return df.parse(str);
        } catch (ParseException e) {
            return null;
        }
    }


    /**
     * 三个时间的 时分秒 对比 倒叙
     *
     * @return
     */
    public static Integer timeCompare(String t1, String t2, String t3) {

        Date t4;
        Date t5;
        Date t6;
        Integer a = 1;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
        try {
            t4 = simpleDateFormat.parse(t1);
            t5 = simpleDateFormat.parse(t2);
            t6 = simpleDateFormat.parse(t3);


            if (t6.getTime() > t5.getTime() && t5.getTime() > t4.getTime()) {
                a = 0;
            }
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return a;
    }

    /**
     * Discreption:获取两个日期之间的所有日期
     * 2020-07-02 ---- 2020-07-04 返回 [2020-07-02,2020-07-03,2020-07-04]
     */
    public static List<String> getDateRange(Date date1, Date date2) {

        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        int i = DateUtils.daysBetween(date1, date2);
        System.out.println("i:" + i);

        int j = 0;
        ArrayList<String> scheduleDateList = new ArrayList<>();
        for (j = 0; j <= i; j++) {
            Date date = DateUtils.dateAddDays(date1, j);
            String format = simpleDateFormat.format(date);
            scheduleDateList.add(format);
        }
        System.out.println(scheduleDateList);
        return scheduleDateList;
    }

    /**
     * 判断日期范围是否有重叠(日期到天)
     */
//    public static boolean overlapping(List<String> list) {
//        if (list == null || list.size() <= 1) {
//            return false;
//        }
//        for (int i = 0; i < list.size(); i++) {
//            String date1[] = list.get(i).split(" ");
//            Date beginDate1 = DateUtil.toShortDate(date1[0]);
//            Date endDate1 = DateUtil.toShortDate(date1[1]);
//            for (int j = i + 1; j < list.size(); j++) {
//                String date2[] = list.get(j).split(" ");
//                Date beginDate2 = DateUtil.toShortDate(date2[0]);
//                Date endDate2 = DateUtil.toShortDate(date2[1]);
//                if (!beginDate2.before(beginDate1)) {
//                    if (!beginDate2.after(endDate1)) {
//                        return true;
//                    }
//                } else if (!endDate2.before(beginDate1)) {
//                    return true;
//                }
//            }
//        }
//        return false;
//    }

    /**
     * 判断两个日期范围是否有重叠(日期到天)
     */
    public static boolean overlap(Date beginDate1, Date endDate1, Date beginDate2, Date endDate2) {

        if (!beginDate2.before(beginDate1)) {
            if (!beginDate2.after(endDate1)) {
                return true;
            }
        } else if (!endDate2.before(beginDate1)) {
            return true;
        }
        System.out.println();
        return false;
    }

    /**
     * 获取当前时间的 时 和 分
     */
    public static String getHourAndSecond() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("HH:mm");
        return df.format(calendar.getTime());
    }

    /**
     * 当前时间是 上午 中午 晚上
     */
    public static Integer getTimeRange() {

        Date date = new Date();
        SimpleDateFormat df = new SimpleDateFormat("HH");
        String str = df.format(date);
        int a = Integer.parseInt(str);
        if (a >= 8 && a <= 12) {
            return 1;
        }
        if (a >= 13 && a <= 17) {
            return 2;
        }
        if (a >= 18 && a <= 22) {
            return 3;
        }
        return 0;
    }

    /*
     * Discreption:
     *获取某天 所在周的 周一
     */
    public static String getOneDayForWeekFirst(String oneDay) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            cal.setTime(sdf.parse(oneDay));
        } catch (ParseException e) {
            e.printStackTrace();
        }
        // 设置一个星期的第一天，按中国的习惯一个星期的第一天是星期一
        cal.setFirstDayOfWeek(Calendar.MONDAY);
        // 判断要计算的日期是否是周日，如果是则减一天计算周六的，否则会出问题，计算到下一周去了
        int dayWeek = cal.get(Calendar.DAY_OF_WEEK);
        if (1 == dayWeek) {
            cal.add(Calendar.DAY_OF_MONTH, -1);
        }
        // 获得当前日期是一个星期的第几天
        int day = cal.get(Calendar.DAY_OF_WEEK);
        // 获取该周第一天
        cal.add(Calendar.DATE, cal.getFirstDayOfWeek() - day);
        String beginDate = sdf.format(cal.getTime());
        // 获取该周最后一天
        cal.add(Calendar.DATE, 6);
        String endDate = sdf.format(cal.getTime());
        System.out.println("beginDate:" + beginDate);
        System.out.println("endDate:" + endDate);
        return beginDate;
    }

    /*
     * Discreption:
     *获取某天 所在周的 周日
     */
    public static String getOneDayForWeekLast(String oneDay) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            cal.setTime(sdf.parse(oneDay));
        } catch (ParseException e) {
            e.printStackTrace();
        }
        cal.setFirstDayOfWeek(Calendar.MONDAY);
        int dayWeek = cal.get(Calendar.DAY_OF_WEEK);
        if (1 == dayWeek) {
            cal.add(Calendar.DAY_OF_MONTH, -1);
        }
        int day = cal.get(Calendar.DAY_OF_WEEK);
        cal.add(Calendar.DATE, cal.getFirstDayOfWeek() - day);
        String beginDate = sdf.format(cal.getTime());
        cal.add(Calendar.DATE, 6);
        String endDate = sdf.format(cal.getTime());
        return endDate;
    }

    /*
     * Discreption:
     *获取某两天之间 间隔 几周 不包含这两天
     */
    public static Long getWeekDayToDay(String start, String end) {

        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        long l = 0;
        try {
            long from = df.parse(start).getTime();
            long to = df.parse(end).getTime();
            l = (to - from) / (1000 * 3600 * 24 * 7);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return l;
    }

    public static Integer getDifMonth(Date start, Date end) {
        if (start.after(end)) {
            Date t = start;
            start = end;
            end = t;
        }
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(start);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(end);
        Calendar temp = Calendar.getInstance();
        temp.setTime(end);
        temp.add(Calendar.DATE, 1);

        int year = endCalendar.get(Calendar.YEAR) - startCalendar.get(Calendar.YEAR);
        int month = endCalendar.get(Calendar.MONTH) - startCalendar.get(Calendar.MONTH);

        if ((startCalendar.get(Calendar.DATE) == 1) && (temp.get(Calendar.DATE) == 1)) {
            return year * 12 + month + 1;
        } else if ((startCalendar.get(Calendar.DATE) != 1) && (temp.get(Calendar.DATE) == 1)) {
            return year * 12 + month;
        } else if ((startCalendar.get(Calendar.DATE) == 1) && (temp.get(Calendar.DATE) != 1)) {
            return year * 12 + month;
        } else {
            return (year * 12 + month - 1) < 0 ? 0 : (year * 12 + month);
        }

    }

    /*
     * Discreption:
     *获取某天 下几周的 周一
     */
    public static String getNextWeekFirst(String date, Integer min) {
        Date date1 = null;
        try {
            date1 = strToDate(date, "yyyy-MM-dd");
        } catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        int dayofweek = cal.get(Calendar.DAY_OF_WEEK);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(Calendar.DATE, 2 - dayofweek + min * 7);
        String s = dateToSimpleString(getDayStartTime(cal.getTime()));
        return s;
    }

    /*
     * Discreption:
     *获取某天 下几周的 周日
     */
    public static String getNextWeekLast(String date, Integer min) {
        Date date1 = null;
        try {
            date1 = strToDate(getNextWeekFirst(date, min), "yyyy-MM-dd");
        } catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        cal.add(Calendar.DAY_OF_WEEK, 6);
        Date weekEndSta = cal.getTime();
        String s = dateToSimpleString(getDayEndTime(weekEndSta));
        return s;
    }

    /*
     * Discreption:
     *两个日期间 相差的 月份
     */
    public static List<Integer> getMonth(String startTime, String endTime) {

        List<Integer> time = new ArrayList<>();
        String start;
        String end;
        if (startTime.charAt(5) == 48) {
            start = startTime.substring(6, 7);
        } else {
            start = startTime.substring(5, 7);
        }

        if (endTime.charAt(5) == 48) {
            end = endTime.substring(6, 7);
        } else {
            end = endTime.substring(5, 7);
        }

        for (int i = Integer.valueOf(start); i <= Integer.valueOf(end); i++) {
            time.add(i);
        }

        if (time.size() == 2) {
            Integer i = time.get(0);
            Integer k = time.get(1);
            if (i.equals(k)) {
                time.remove(1);
            }
        }
        return time;
    }

    /*
     * Discreption:
     *某日期当前月的 最后一天
     */
    public static String getLastDayOfMonth(String yearMonth) {
        int year = Integer.parseInt(yearMonth.split("-")[0]);
        int month = Integer.parseInt(yearMonth.split("-")[1]);
        Calendar cal = Calendar.getInstance();
        // 设置年份
        cal.set(Calendar.YEAR, year);
        // 设置月份
        // cal.set(Calendar.MONTH, month - 1);
        //设置当前月的上一个月
        cal.set(Calendar.MONTH, month);
        // 获取某月最大天数
        //int lastDay = cal.getActualMaximum(Calendar.DATE);
        //获取月份中的最小值，即第一天
        int lastDay = cal.getMinimum(Calendar.DATE);
        // 设置日历中月份的最大天数
        //cal.set(Calendar.DAY_OF_MONTH, lastDay);
        //上月的第一天减去1就是当月的最后一天
        cal.set(Calendar.DAY_OF_MONTH, lastDay - 1);
        // 格式化日期
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(cal.getTime());
    }

    /*
     * @Description:获取时间段中自然周
     * @author:liyp  String a = "2020-08-24";
        String b = "2020-08-26";
        [{week=2020-08-30, mon=2020-08-24}]
     **/
    public static List<Map<String, String>> getBetweenWeeks(String startDate, String endDate) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        //定义起始日期
        Date start = sdf.parse(startDate);
        //定义结束日期
        Date end = sdf.parse(endDate);

        List<Map<String, String>> result = new ArrayList<Map<String, String>>();
        Calendar tempStart = Calendar.getInstance();
        tempStart.setTime(start);

        Calendar tempEnd = Calendar.getInstance();
        tempEnd.setTime(end);
        while (tempStart.before(tempEnd) || tempStart.equals(tempEnd)) {
            Map<String, String> map = new HashMap<String, String>(16);
            int we = tempStart.get(Calendar.DAY_OF_WEEK);
            if (we == 2) {
                map.put("mon", sdf.format(tempStart.getTime()));
            }
            //检测map是否为空
            if (map.isEmpty()) {
                tempStart.add(Calendar.DAY_OF_YEAR, 1);
            } else {
                tempStart.add(Calendar.DAY_OF_YEAR, 6);
                map.put("week", sdf.format(tempStart.getTime()));
                result.add(map);
            }
        }
        return result;
    }


    /*
     * Discreption:str转date "yyyy-MM-dd"
     */
    public static Date strToDateNoTry(String str) {
        Date date = null;
        try {
            date = strToDate(str, SIMPLE_FORMAT);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }


    public static Date strToDateNoTryForMinute(String str) {
        Date date = null;
        try {
            date = strToDate(str, SIMPLE_TIME_FORMAT_MINUTE);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    /*
     * Discreption:得到某天后几周的时间
     */
    public static Date getNextWeek(String date, Integer min) {
        Date date1 = null;
        try {
            date1 = DateUtils.strToDate(date, "yyyy-MM-dd");
        } catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        cal.add(Calendar.DATE, min * 7);
        Date week = cal.getTime();
        String s = DateUtils.dateToSimpleString(week);
        Date date2 = null;
        try {
            date2 = strToDate(s, "yyyy-MM-dd");
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return date2;
    }

    /*
     * Discreption:得到某天后几周的时间集合 包括入参时间
     */
    public static List<String> getOneDayNextWeek(List<String> range, Integer min) {

        List<String> dateRes = new ArrayList<>();
        for (String str : range) {
            int i = 0;
            for (i = 1; i <= min; i++) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(strToDateNoTry(str));
                cal.add(Calendar.DATE, i * 7);
                Date week = cal.getTime();
                String s = DateUtils.dateToSimpleString(week);
                dateRes.add(s);
            }
        }
        dateRes.addAll(range);
        return dateRes;
    }

    /*
     * Discreption:得到某天后几周的时间集合 不包括入参时间
     */
    public static List<String> getOneDayNextWeekTwo(List<String> range, Integer min) {

        List<String> dateRes = new ArrayList<>();
        for (String str : range) {
            int i = 0;
            for (i = 1; i <= min; i++) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(strToDateNoTry(str));
                cal.add(Calendar.DATE, i * 7);
                Date week = cal.getTime();
                String s = DateUtils.dateToSimpleString(week);
                dateRes.add(s);
            }
        }
        return dateRes;
    }

    /*
     * Discreption: true 有重叠
     */
    public static Boolean rangeCompare(Date date1, Date date2, Date date3, Date date4) {

        Boolean flag = true;
        int f1 = date1.compareTo(date3);
        int f2 = date3.compareTo(date2);
        int f3 = date2.compareTo(date4);
        int f4 = date1.compareTo(date4);

        //左跨
        boolean b1 = WhetherEnum.FORBID.getValue().equals(f1);
        boolean b = WhetherEnum.ALLOW.getValue().equals(f2) || WhetherEnum.EQU.getValue().equals(f2);
        if (b1 && b) {
            flag = false;
        }

//        if(WhetherEnum.FORBID.getValue().equals(f1) && (WhetherEnum.ALLOW.getValue().equals(f2) || WhetherEnum.EQU.getValue().equals(f2))){
//           flag=false;
//       }
        //右跨
        boolean b2 = WhetherEnum.EQU.getValue().equals(f4) || WhetherEnum.ALLOW.getValue().equals(f4);
        if (WhetherEnum.ALLOW.getValue().equals(f3) && b2) {
            flag = false;
        }
//        if(WhetherEnum.ALLOW.getValue().equals(f3) &&
//                (WhetherEnum.EQU.getValue().equals(f4) || WhetherEnum.ALLOW.getValue().equals(f4))){
//            flag=false;
//        }
        return flag;
    }


    /**
     * 判断两个时间的大小 是否后面那个大于或等于前面那个 格式 yyyy-MM-dd hh:mm:ss
     *
     * @param startDate
     * @param endDate
     * @return true为是 false为否
     */
    public static boolean dateCompare(String startStr, String endStr) {

        Date startDate = null;
        Date endDate = null;
        try {
            startDate = strToDate(startStr, FULL_FORMAT);
            endDate = strToDate(endStr, FULL_FORMAT);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        if (startDate.before(endDate) || startDate.compareTo(endDate) == 0) {
            return true;
        }
        return false;
    }

    /**
     * 分钟转小时
     */
    public static String formatTime(int minuteStr) {
        String resultStr = "";
        if (!StringUtils.isEmpty(Integer.toString(minuteStr))) {
            if (minuteStr != 0) {
                if (minuteStr / 60 == 0) {
                    resultStr = minuteStr % 60 + "分";
                } else {
                    if (minuteStr % 60 == 0) {
                        resultStr = minuteStr / 60 + "小时";
                    } else {
                        resultStr = (minuteStr / 60 + "小时" + minuteStr % 60 + "分");
                    }
                }
            } else {
                resultStr = "0时0分";
            }
        } else {
            resultStr = "0时0分";
        }
        return resultStr;
    }

    public static long secondsBetween1(Date date1, Date date2) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        long time1 = cal.getTimeInMillis();
        cal.setTime(date2);
        long time2 = cal.getTimeInMillis();
        long betweenDays = (time2 - time1) / 1000;
        return betweenDays;
    }

    /**
     * 计算两个日期相差的秒数 date2-date1
     *
     * @param date1
     * @param date2
     * @return
     */
    public static int secondBetween(Date date1, Date date2) {
        if (date1.after(date2)) {
            return 0;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        long time1 = cal.getTimeInMillis();
        cal.setTime(date2);
        long time2 = cal.getTimeInMillis();
        long betweenDays = (time2 - time1) / 1000;
        return Integer.parseInt(String.valueOf(betweenDays));
    }

    /**
     * 某日期当前月的 第一天
     *
     * @param yearMonth
     * @return
     */
    public static String getStartDayOfMonth(String yearMonth) {
        int year = Integer.parseInt(yearMonth.split("-")[0]);
        int month = Integer.parseInt(yearMonth.split("-")[1]);
        Calendar cal = Calendar.getInstance();
        // 设置年份
        cal.set(Calendar.YEAR, year);
        // 设置月份
        // cal.set(Calendar.MONTH, month - 1);
        //设置当前月的上一个月
        cal.set(Calendar.MONTH, month - 1);
        // 获取某月最大天数
        //int lastDay = cal.getActualMaximum(Calendar.DATE);
        //获取月份中的最小值，即第一天
        int lastDay = cal.getMinimum(Calendar.DATE);
        // 设置日历中月份的最大天数
        //cal.set(Calendar.DAY_OF_MONTH, lastDay);
        //上月的第一天减去1就是当月的最后一天
        cal.set(Calendar.DAY_OF_MONTH, lastDay);
        // 格式化日期
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(cal.getTime());
    }


    /**
     * 计算一个月的月初日期和月末日期
     *
     * @param time
     * @return
     */
    public static List<String> getMonthBeginAndEnd(String time) {
        String begin = "01";
        String end1 = "28";
        String end2 = "29";
        String end3 = "30";
        String end4 = "31";
        //大月
        Integer[] bigMonth = {1, 3, 5, 7, 8, 10, 12};
        Integer[] smallMonth = {4, 6, 9, 11};

        List<Integer> bigMonthList = new ArrayList<>();
        bigMonthList.addAll(Arrays.asList(bigMonth));
        List<Integer> smallMonthList = new ArrayList<>();
        smallMonthList.addAll(Arrays.asList(smallMonth));


        //获得当前年月信息
        int year = Integer.parseInt(time.substring(0, 4));
        int month = Integer.parseInt(time.substring(5, 7));

        List<String> result = new ArrayList<>();

        //判断是否为闰年
        if ((year % 4 == 0 && year % 100 != 0) || year % 400 == 0) {
            StringBuffer monthBegin = new StringBuffer();
            StringBuffer monthEnd = new StringBuffer();
            if ("2".equals(month) && month < 10) {
                monthBegin.append(year).append("-").append(0).append(month).append("-").append(begin);
                monthEnd.append(year).append("-").append(0).append(month).append("-").append(end2);
            } else {
                monthBegin.append(year).append("-").append(month).append("-").append(begin);
                monthEnd.append(year).append("-").append(month).append("-").append(end2);
            }
        } else {
            StringBuffer monthBegin = new StringBuffer();
            StringBuffer monthEnd = new StringBuffer();
            //非闰年
            if ("2".equals(month) && month < 10) {
                monthBegin.append(year).append("-").append(0).append(month).append("-").append(begin);
                monthEnd.append(year).append("-").append(0).append(month).append("-").append(end1);
            }
            if ("2".equals(month) && month >= 10) {
                monthBegin.append(year).append("-").append(month).append("-").append(begin);
                monthEnd.append(year).append("-").append(month).append("-").append(end1);
            }
            if (bigMonthList.contains(month) && month < 10) {
                monthBegin.append(year).append("-").append(0).append(month).append("-").append(begin);
                monthEnd.append(year).append("-").append(0).append(month).append("-").append(end4);
            }
            if (bigMonthList.contains(month) && month >= 10) {
                monthBegin.append(year).append("-").append(month).append("-").append(begin);
                monthEnd.append(year).append("-").append(month).append("-").append(end4);
            }
            if (smallMonthList.contains(month) && month < 10) {
                monthBegin.append(year).append("-").append(0).append(month).append("-").append(begin);
                monthEnd.append(year).append("-").append(0).append(month).append("-").append(end3);
            }
            if (bigMonthList.contains(month) && month >= 10) {
                monthBegin.append(year).append("-").append(month).append("-").append(begin);
                monthEnd.append(year).append("-").append(month).append("-").append(end3);
            }

            result.add(monthBegin.toString());
            result.add(monthEnd.toString());
        }

        return result;
    }


    public static int getAgeByBirth(Date birthDay) throws ParseException {
        int age = 0;
        Calendar cal = Calendar.getInstance();
        if (cal.before(birthDay)) { //出生日期晚于当前时间，无法计算
            throw new IllegalArgumentException(
                    "The birthDay is before Now.It's unbelievable!");
        }
        int yearNow = cal.get(Calendar.YEAR);  //当前年份
        int monthNow = cal.get(Calendar.MONTH);  //当前月份
        int dayOfMonthNow = cal.get(Calendar.DAY_OF_MONTH); //当前日期
        cal.setTime(birthDay);
        int yearBirth = cal.get(Calendar.YEAR);
        int monthBirth = cal.get(Calendar.MONTH);
        int dayOfMonthBirth = cal.get(Calendar.DAY_OF_MONTH);
        age = yearNow - yearBirth;   //计算整岁数
        if (monthNow <= monthBirth) {
            if (monthNow == monthBirth) {
                if (dayOfMonthNow < dayOfMonthBirth) {
                    age--;//当前日期在生日之前，年龄减一
                }
            } else {
                age--;//当前月份在生日之前，年龄减一
            }
        }
        return age;
    }

    /**
     * 将某个时间往后推day天
     *
     * @param currentDate
     * @param day
     * @return
     */
    public static Date getAfterDay(Date currentDate, int day) {
        // 创建Calendar对象并设置为当前日期
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentDate);
        // 往后推30天
        calendar.add(Calendar.DAY_OF_MONTH, day);
        // 获取推迟后的日期
        Date futureDate = calendar.getTime();

        return futureDate;
    }

    public static Date getQingMingBeforeDay(Date currentDate) throws ParseException {
        // 设置清明节日期为4月4日或4月5日
        String qingMingDateStr = getFormatDateString(currentDate, YEAR) + "-04-04"; // 以2024年为例
        Date qingMingDate = parseDate(qingMingDateStr, SIMPLE_FORMAT);

        // 使用Calendar类处理日期
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(qingMingDate);
        calendar.add(Calendar.DAY_OF_YEAR, -1); // 获取清明节前一天

        // 将获取到的日期转换为Date对象
        Date qingMingEveDate = calendar.getTime();
        return qingMingEveDate;
    }

    public static Date getLaborBeforeDay(Date currentDate) throws ParseException {
        // 设置劳动节日期为5月1日
        String laborDayStr = getFormatDateString(currentDate, YEAR) + "-05-01"; // 以2024年为例
        Date laborDay = parseDate(laborDayStr, SIMPLE_FORMAT);

        // 使用Calendar类处理日期
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(laborDay);
        calendar.add(Calendar.DAY_OF_YEAR, -1); // 获取劳动节前一天

        // 将获取到的日期转换为Date对象
        Date laborDayEve = calendar.getTime();
        return laborDayEve;
    }

    public static Date getDuanWuBeforeDay(Date currentDate) throws ParseException {

        // 设置端午节日期为6月8日
        String duanWuDayStr = getFormatDateString(currentDate, YEAR) + "-06-08"; // 以2024年为例
        Date duanWuDay = parseDate(duanWuDayStr, SIMPLE_FORMAT);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(duanWuDay);
        // 往前推一天
        calendar.add(Calendar.DAY_OF_YEAR, -1);

        Date duanwuDayEve = calendar.getTime();

        return duanwuDayEve;
    }

    public static Date getZhongQiuBeforeDay(Date currentDate) throws ParseException {

        // 设置端午节日期为6月8日
        String zhongQiuDayStr = getFormatDateString(currentDate, YEAR) + "-09-14"; // 以2024年为例
        Date zhongQiuDay = parseDate(zhongQiuDayStr, SIMPLE_FORMAT);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(zhongQiuDay);
        // 往前推一天
        calendar.add(Calendar.DAY_OF_YEAR, -1);

        Date zhongQiuDayEve = calendar.getTime();

        return zhongQiuDayEve;
    }

    public static Date getGuoQingBeforeDay(Date currentDate) throws ParseException {

        // 设置国庆节日期为10月01日
        String guoQingDayStr = getFormatDateString(currentDate, YEAR) + "-10-01"; // 以2024年为例
        Date guoQingDay = parseDate(guoQingDayStr, SIMPLE_FORMAT);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(guoQingDay);
        // 往前推一天
        calendar.add(Calendar.DAY_OF_YEAR, -1);

        Date guoQingDayEve = calendar.getTime();

        return guoQingDayEve;
    }

}
