package com.ebaiyihui.family.doctor.server.util;

import com.ebaiyihui.family.doctor.server.common.enums.GenderEnum;
import org.apache.commons.lang.StringUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * @ClassName: IDCardUtil
 * @Author:yanliang
 * @Date:2024/3/13 16:40
 * @Description
 */

public class IDCardUtil {

    /**
     * 通过身份证号码获取年龄
     *
     * @param idcard
     * @return
     * @throws ParseException
     * @author ZhangWei
     */
    public static Integer getAge(String idcard) {
        if (idcard == null) {
            return null;
        }
        //身份证位数不足统一返回null
        if (idcard.length() != 18) {
            return null;
        }
        return getAgeByBirthDates(idcard.substring(6, 14), "yyyyMMdd");
    }

    public static Integer getAgeByBirthDates(String birthDateStr) {
        return getAgeByBirthDates(birthDateStr, "yyyy-MM-dd");
    }

    public static Integer getAgeByBirthDates(String birthDateStr, String format) {
        if (birthDateStr == null || format == null) {
            return 0;
        }
        Date birthDate;
        try {
            birthDate = new SimpleDateFormat(format).parse(birthDateStr);
        } catch (ParseException e) {
            return 0;
        }
        // 判断出身日期的合法性
        Calendar calendar = Calendar.getInstance();
        if (calendar.before(birthDate)) {
            return 0;
        }
        // 获取当前时间的 年 月 日
        int yearNow = calendar.get(Calendar.YEAR);
        int monthNow = calendar.get(Calendar.MONTH);
        int dayOfMonthNow = calendar.get(Calendar.DAY_OF_MONTH);
        // 获取出身日期的年月日
        calendar.setTime(birthDate);
        int yearBirth = calendar.get(Calendar.YEAR);
        int monthBirth = calendar.get(Calendar.MONTH);
        int dayOfMonthBirth = calendar.get(Calendar.DAY_OF_MONTH);
        int age = yearNow - yearBirth;
        if (monthNow <= monthBirth) {
            if (monthNow == monthBirth) {
                if (dayOfMonthNow < dayOfMonthBirth) {
                    age--;
                }
            } else {
                age--;
            }
        }
        return age;
    }

    public static String getGender(String idcard) {
        if (StringUtils.isBlank(idcard)) {
            return null;
        }
        String gender = null;
        char[] number = idcard.toCharArray();
        boolean flag = true;
        int oldLength = 15;
        int newLength = 18;
        if (number.length == oldLength) {
            for (int x = 0; x < number.length; x++) {
                if (!flag) {
                    return null;
                }
                flag = Character.isDigit(number[x]);
            }
        } else if (number.length == newLength) {
            for (int x = 0; x < number.length - 1; x++) {
                if (!flag) {
                    return null;
                }
                flag = Character.isDigit(number[x]);
            }
        }
        if (flag && idcard.length() == oldLength) {
            gender = Integer.parseInt(idcard.substring(idcard.length() - 3, idcard.length()))
                    % 2 == 0 ? GenderEnum.FEMALE.getDesc() : GenderEnum.MALE.getDesc();
        } else if (flag && idcard.length() == newLength) {
            gender = Integer.parseInt(idcard.substring(idcard.length() - 4, idcard.length() - 1)) % 2 == 0
                    ? GenderEnum.FEMALE.getDesc() : GenderEnum.MALE.getDesc();
        }
        return gender;
    }

    public static Integer getGenderForInteger(String idcard) {
        if (StringUtils.isBlank(idcard)) {
            return null;
        }
        Integer gender = null;
        char[] number = idcard.toCharArray();
        boolean flag = true;
        int oldLength = 15;
        int newLength = 18;
        if (number.length == oldLength) {
            for (int x = 0; x < number.length; x++) {
                if (!flag) {
                    return null;
                }
                flag = Character.isDigit(number[x]);
            }
        } else if (number.length == newLength) {
            for (int x = 0; x < number.length - 1; x++) {
                if (!flag) {
                    return null;
                }
                flag = Character.isDigit(number[x]);
            }
        }
        if (flag && idcard.length() == oldLength) {
            gender = Integer.parseInt(idcard.substring(idcard.length() - 3, idcard.length()))
                    % 2 == 0 ? GenderEnum.FEMALE.getValue() : GenderEnum.MALE.getValue();
        } else if (flag && idcard.length() == newLength) {
            gender = Integer.parseInt(idcard.substring(idcard.length() - 4, idcard.length() - 1)) % 2 == 0
                    ? GenderEnum.FEMALE.getValue() : GenderEnum.MALE.getValue();
        }
        return gender;
    }

    /**
     * 通过身份证号码获取生日 格式 yyyy-MM-dd
     */
    public static String getBirthByIdCard(String idCard) {
        if (idCard == null) {
            return null;
        }
        //身份证位数不足统一返回null
        if (idCard.length() != 18) {
            return null;
        }
        String year = idCard.substring(6, 10);
        String month = idCard.substring(10, 12);
        String day = idCard.substring(12, 14);
        String birth = year + "-" + month + "-" + day;
        return birth;

    }
}
