package com.ebaiyihui.family.doctor.server.util;

import com.github.pagehelper.Page;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;

/**
 * @ClassName: PageUtil
 * @Author:yanliang
 * @Date:2024/3/13 15:31
 * @Description
 */

public final class PageUtil<T> implements Serializable {

    private static final long serialVersionUID = 1L;


    /**
     * 总记录数
     */
    private long total;

    /**
     * 结果集
     */
    private List<T> list;

    private Object object;

    public PageUtil() {
        super();
    }

    public PageUtil(List<T> list) {
        if (list instanceof Page) {
            Page page = (Page) list;
            this.list = page;
            this.total = page.getTotal();
        } else if (list instanceof Collection) {
            this.list = list;
            this.total = list.size();
        }
    }

    public static int getTotalPage(int total, int pageSize) {
        int totalPage = (total + pageSize - 1) / pageSize;
        return totalPage;
    }

    /**
     * Getter method for property <tt>total</tt>.
     *
     * @return property value of total
     */
    public long getTotal() {
        return total;
    }

    /**
     * Setter method for property <tt>total</tt>.
     *
     * @param total value to be assigned to property total
     */
    public void setTotal(long total) {
        this.total = total;
    }

    /**
     * Getter method for property <tt>list</tt>.
     *
     * @return property value of list
     */
    public List<T> getList() {
        return list;
    }

    /**
     * Setter method for property <tt>list</tt>.
     *
     * @param list value to be assigned to property list
     */
    public void setList(List<T> list) {
        this.list = list;
    }

    public Object getObject() {
        return object;
    }

    public void setObject(Object object) {
        this.object = object;
    }
}
