package com.ebaiyihui.family.doctor.server.util;

import cn.hutool.core.util.CharsetUtil;
import cn.hutool.crypto.digest.DigestAlgorithm;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import lombok.extern.slf4j.Slf4j;

import java.lang.reflect.Field;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/**
 * @ClassName: SignUtils
 * @Author:yanliang
 * @Date:2024/3/18 14:52
 * @Description
 */
@Slf4j
public class SignUtils {

    public final static String NO_STR = "0";

    public static String getSignatureToStr(Map<String, String> params, String secret) {
        // 先将参数以其参数名的字典序升序进行排序
        Map<String, String> sortedParams = new TreeMap<String, String>(params);
        Set<Map.Entry<String, String>> entrys = sortedParams.entrySet();
        // 遍历排序后的字典，将所有参数按"key=value"格式拼接在一起
        StringBuilder basestring = new StringBuilder();
        for (Map.Entry<String, String> param : entrys) {
            basestring.append(param.getKey()).append("=").append(param.getValue());
        }
        basestring.append(secret);

        log.info("加密前参数：{}", basestring.toString());
        // 使用MD5对待签名串求签
        byte[] bytes = null;
        try {
            MessageDigest md5 = MessageDigest.getInstance(DigestAlgorithm.MD5.getValue());
            bytes = md5.digest(basestring.toString().getBytes(CharsetUtil.CHARSET_UTF_8));
        } catch (Exception ex) {
            log.error("错误信息：{}", ex);
        }
        // 将MD5输出的二进制结果转换为小写的十六进制
        StringBuilder sign = new StringBuilder();
        for (int i = 0; i < bytes.length; i++) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() == 1) {
                sign.append(NO_STR);
            }
            sign.append(hex);
        }
        return sign.toString();
    }

    /**
     * 检验参数 并返回Map
     */
    public static Map<String, String> paramToMap(Object obj) {
        /*** 过滤多余参数 并转换为Map<String, String> ***/
        Map<String, Object> objMap = convertObjectToMap(obj);
        // 类型转换
        Map<String, String> strMap = JSON.parseObject(
                JSON.toJSONString(objMap),
                new TypeReference<HashMap<String, String>>() {
                }
        );
        return strMap;
    }

    public static Map<String, Object> convertObjectToMap(Object object) {
        Map<String, Object> map = new HashMap<>();
        try {
            Class<?> clazz = object.getClass();
            Field[] fields = clazz.getDeclaredFields();
            for (Field field : fields) {
                field.setAccessible(true);
                String fieldName = field.getName();
                Object fieldValue = field.get(object);
                map.put(fieldName, fieldValue);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }
}
