package com.ebaiyihui.family.doctor.server.util;

import java.util.Random;
import java.util.UUID;

/**
 * @ClassName: UUIDUtil
 * @Author:yanliang
 * @Date:2024/3/13 09:57
 * @Description
 */

public class UUIDUtil {

    /**
     * 得到UUID
     *
     * @return
     */
    public static String getUUID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }


    /**
     * 生成返回给界面的唯一ID，防止数据库的自增ID被获取
     *
     * @return
     */
    public static String generateViewId() {
        Long timestamp = System.currentTimeMillis();
        // 生成三位随机数
        StringBuilder result = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < 6; i++) {
            result.append(random.nextInt(10));
        }
        return String.valueOf(timestamp) + result.toString();
    }

}
