package com.ebaiyihui.family.doctor.server.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.doctoruser.api.pojo.dto.UcConfigurationDTO;
import com.doctoruser.api.pojo.vo.*;
import com.doctoruser.api.pojo.vo.account.DoctorIdReqVO;
import com.doctoruser.api.pojo.vo.account.DoctorInfoRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.HttpKit;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.web.client.RestTemplate;

import java.util.List;

/**
 * @ClassName: UserRestTemplateUtil
 * @Author:yanliang
 * @Date:2024/3/15 16:51
 * @Description
 */
@Slf4j
public class UserRestTemplateUtil {

    public static UserInfoByUserIdRespVO getUserInfo(GetUserInfoByUserIdReqVO getUserInfoByUserIdReqVO, String url) {
        log.info("1用户调用" + JSON.toJSONString(getUserInfoByUserIdReqVO));
        BaseResponse response = null;
        try {
            String result = HttpKit.jsonPost(url, JSON.toJSONString(getUserInfoByUserIdReqVO));
            response = JSONObject.toJavaObject(JSONObject.parseObject(result), BaseResponse.class);
            log.info("response:{}" + JSON.toJSONString(response));

        } catch (Exception e) {
            log.error("调用用户资料接口失败" + e.getMessage());
        }

        log.info("response :{}", JSON.toJSONString(response));
        if ("-1".equals(response.getErrCode())) {
            log.info("=================用户调用失败================");
            return null;
        }
        UserInfoByUserIdRespVO userInfoByUserIdRespVO = JSONObject.parseObject(JSONObject.toJSONString(response.getData()), UserInfoByUserIdRespVO.class);
        return userInfoByUserIdRespVO;
    }

    /**
     * @param findUserIdListReq
     */
    public static List<FindUserIdRespVO> queryUserIdList(FindUserIdListReq findUserIdListReq, String url) {
        log.info("2用户调用" + JSON.toJSONString(findUserIdListReq));
        BaseResponse response = null;
        try {
            String result = HttpKit.jsonPost(url, JSON.toJSONString(findUserIdListReq));
            response = JSONObject.toJavaObject(JSONObject.parseObject(result), BaseResponse.class);
            log.info("response:{}" + JSON.toJSONString(response));
        } catch (Exception e) {
            log.error("调用批量查询用户id接口失败" + e.getMessage());
        }

        log.info("response :{}", JSON.toJSONString(response));
        if ("-1".equals(response.getErrCode())) {
            log.info("=================用户调用失败================");
            return null;
        }
        Object data = response.getData();
        List<FindUserIdRespVO> userIdResplist =
                JSONObject.parseObject(JSONObject.toJSONString(data), new TypeReference<List<FindUserIdRespVO>>() {
                });
        log.info("userIdResplist:{}" + userIdResplist.toString());

        return userIdResplist;
    }

    /**
     * @param doctorIdReqVO
     */
    public static DoctorInfoRespVO queryDoctorByDoctorId(DoctorIdReqVO doctorIdReqVO, String url) {
        log.info("3用户调用" + JSON.toJSONString(doctorIdReqVO));
        HttpHeaders headers = new HttpHeaders();

        //定义请求参数类型，这里用json所以是MediaType.APPLICATION_JSON
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity<DoctorIdReqVO> request = new HttpEntity<>(doctorIdReqVO, headers);
        RestTemplate restTemplate = new RestTemplate();
        log.info("url :{}", JSON.toJSONString(url));
        log.info("request :{}", JSON.toJSONString(request));
        BaseResponse response = restTemplate.postForObject(url, request, BaseResponse.class);
        log.info("response :{}", JSON.toJSONString(response));
        if ("-1".equals(response.getErrCode())) {
            log.info("=================用户调用失败================");
            return null;
        }
        DoctorInfoRespVO doctorInfoResp =
                JSONObject.parseObject(JSONObject.toJSONString(response.getData()), DoctorInfoRespVO.class);
        return doctorInfoResp;
    }

    /**
     * 获取 配置详情
     *
     * @param appCode
     * @return
     */
    public static String getConfigurationDetail(String appCode, String type, String url) {
        UcConfigurationDTO ucConfigurationDTO = new UcConfigurationDTO();
        ucConfigurationDTO.setType(type);
        ucConfigurationDTO.setAppCode(appCode);
        BaseResponse response = null;
        try {
            String result = HttpKit.jsonPost(url, JSON.toJSONString(ucConfigurationDTO));
            response = JSONObject.toJavaObject(JSONObject.parseObject(result), BaseResponse.class);

        } catch (Exception e) {
            log.error("调用推送接口失败" + e.getMessage());
        }
        log.info("获取配置详情 返回:{}", JSON.toJSONString(response));
        UcConfigurationVO ucConfigurationVO = JSONObject.parseObject(JSONObject.toJSONString(response.getData()), UcConfigurationVO.class);
        log.info("获取配置详情看json解析: {}", JSON.toJSONString(ucConfigurationVO));
        return ucConfigurationVO.getClientCode();
    }
}
